/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.util.MessageListenerConfigParser;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageListenerConfigParserImpl
implements MessageListenerConfigParser {
    private static final Logger _logger = LogDomains.getLogger(MessageListenerConfigParserImpl.class, (String)"javax.enterprise.resource.resourceadapter");

    public String getActivationSpecClass(ConnectorDescriptor desc, String messageListenerType) throws ConnectorRuntimeException {
        if (desc == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        MessageListener[] messageListeners = ddTransformUtil.getMessageListeners(desc);
        if (messageListeners != null) {
            for (int i = 0; i < messageListeners.length; ++i) {
                if (!messageListenerType.equals(messageListeners[i].getMessageListenerType())) continue;
                return messageListeners[i].getActivationSpecClass();
            }
        }
        return null;
    }

    public String[] getMessageListenerTypes(ConnectorDescriptor desc) throws ConnectorRuntimeException {
        if (desc == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        MessageListener[] messageListeners = ddTransformUtil.getMessageListeners(desc);
        String[] messageListenerTypes = null;
        if (messageListeners != null) {
            messageListenerTypes = new String[messageListeners.length];
            for (int i = 0; i < messageListeners.length; ++i) {
                messageListenerTypes[i] = messageListeners[i].getMessageListenerType();
            }
        }
        return messageListenerTypes;
    }

    public Properties getJavaBeanProps(ConnectorDescriptor desc, String messageListenerType, String rarName) throws ConnectorRuntimeException {
        if (desc == null || messageListenerType == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        MessageListener[] allMessageListeners = ddTransformUtil.getMessageListeners(desc);
        MessageListener messageListener = null;
        for (int i = 0; i < allMessageListeners.length; ++i) {
            if (!messageListenerType.equals(allMessageListeners[i].getMessageListenerType())) continue;
            messageListener = allMessageListeners[i];
        }
        if (messageListener == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "No such MessageListener found in ra.xml", messageListenerType);
            }
            throw new ConnectorRuntimeException("No such MessageListener found in ra.xml : " + messageListenerType);
        }
        Properties mergedVals = null;
        Set ddVals = messageListener.getConfigProperties();
        String className = messageListener.getActivationSpecClass();
        if (className != null && className.length() != 0) {
            Properties introspectedVals = configParserUtil.introspectJavaBean(className, ddVals, false, rarName);
            mergedVals = configParserUtil.mergeProps(ddVals, introspectedVals);
        }
        return mergedVals;
    }

    public Properties getJavaBeanReturnTypes(ConnectorDescriptor desc, String messageListenerType, String rarName) throws ConnectorRuntimeException {
        if (desc == null || messageListenerType == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        MessageListener[] allMessageListeners = ddTransformUtil.getMessageListeners(desc);
        MessageListener messageListener = null;
        for (int i = 0; i < allMessageListeners.length; ++i) {
            if (!messageListenerType.equals(allMessageListeners[i].getMessageListenerType())) continue;
            messageListener = allMessageListeners[i];
        }
        if (messageListener == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "No such MessageListener found in ra.xml", messageListenerType);
            }
            throw new ConnectorRuntimeException("No such MessageListener found in ra.xml : " + messageListenerType);
        }
        Properties mergedVals = null;
        Set ddVals = messageListener.getConfigProperties();
        String className = messageListener.getActivationSpecClass();
        if (className != null && className.length() != 0) {
            Properties introspectedVals = configParserUtil.introspectJavaBeanReturnTypes(className, ddVals, rarName);
            mergedVals = configParserUtil.mergePropsReturnTypes(ddVals, introspectedVals);
        }
        return mergedVals;
    }
}

