/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.spi.TransactionSupport;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.glassfish.resource.common.PoolInfo;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionPoolObjectsUtils {
    public static final String ELEMENT_PROPERTY = "ElementProperty";
    private static final Logger _logger = LogDomains.getLogger(ConnectionPoolObjectsUtils.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final String VALIDATE_ATMOST_EVERY_IDLE_SECS = "com.sun.enterprise.connectors.ValidateAtmostEveryIdleSecs";
    private static final String validateAtmostEveryIdleSecsProperty = System.getProperty("com.sun.enterprise.connectors.ValidateAtmostEveryIdleSecs");
    private static final StringManager localStrings = StringManager.getManager(ConnectionPoolObjectsUtils.class);

    private ConnectionPoolObjectsUtils() {
    }

    public static ConnectorConnectionPool createDefaultConnectorPoolObject(PoolInfo poolInfo, String rarName) {
        ConnectorConnectionPool connectorPoolObj;
        block2: {
            connectorPoolObj = new ConnectorConnectionPool(poolInfo);
            connectorPoolObj.setMaxPoolSize("20");
            connectorPoolObj.setSteadyPoolSize("10");
            connectorPoolObj.setMaxWaitTimeInMillis("7889");
            connectorPoolObj.setIdleTimeoutInSeconds("789");
            connectorPoolObj.setPoolResizeQuantity("2");
            connectorPoolObj.setFailAllConnections(false);
            connectorPoolObj.setMatchConnections(true);
            ConnectionPoolObjectsUtils.setDefaultAdvancedPoolAttributes(connectorPoolObj);
            try {
                connectorPoolObj.setTransactionSupport(ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(rarName));
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.fine("error in setting txSupport");
            }
        }
        return connectorPoolObj;
    }

    private static void setDefaultAdvancedPoolAttributes(ConnectorConnectionPool connectorPoolObj) {
        connectorPoolObj.setMaxConnectionUsage("0");
        connectorPoolObj.setConnectionLeakTracingTimeout("0");
        connectorPoolObj.setConCreationRetryAttempts("0");
        connectorPoolObj.setConCreationRetryInterval("10");
        connectorPoolObj.setValidateAtmostOncePeriod("0");
    }

    public static ConnectorConnectionPool createSunRaConnectorPoolObject(PoolInfo poolInfo, ConnectorDescriptor desc, String rarName) {
        ConnectorConnectionPool connectorPoolObj;
        block4: {
            connectorPoolObj = new ConnectorConnectionPool(poolInfo);
            SunConnector sundesc = desc.getSunDescriptor();
            ResourceAdapter sunRAXML = sundesc.getResourceAdapter();
            connectorPoolObj.setMaxPoolSize((String)sunRAXML.getValue("MaxPoolSize"));
            connectorPoolObj.setSteadyPoolSize((String)sunRAXML.getValue("SteadyPoolSize"));
            connectorPoolObj.setMaxWaitTimeInMillis((String)sunRAXML.getValue("MaxWaitTimeInMillis"));
            connectorPoolObj.setIdleTimeoutInSeconds((String)sunRAXML.getValue("IdleTimeoutInSeconds"));
            connectorPoolObj.setPoolResizeQuantity("2");
            connectorPoolObj.setFailAllConnections(false);
            connectorPoolObj.setMatchConnections(true);
            ConnectionPoolObjectsUtils.setDefaultAdvancedPoolAttributes(connectorPoolObj);
            try {
                connectorPoolObj.setTransactionSupport(ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(rarName));
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.fine("error in setting txSupport");
            }
        }
        boolean validateAtmostEveryIdleSecs = false;
        if (validateAtmostEveryIdleSecsProperty != null && validateAtmostEveryIdleSecsProperty.equalsIgnoreCase("TRUE")) {
            validateAtmostEveryIdleSecs = true;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "CCP.ValidateAtmostEveryIdleSecs.Set", poolInfo);
            }
        }
        connectorPoolObj.setValidateAtmostEveryIdleSecs(validateAtmostEveryIdleSecs);
        return connectorPoolObj;
    }

    public static int convertSpecTxSupportToContainerTxSupport(TransactionSupport.TransactionSupportLevel mcfTS) {
        int containerEquivalentValue;
        switch (mcfTS) {
            case LocalTransaction: {
                containerEquivalentValue = 1;
                break;
            }
            case NoTransaction: {
                containerEquivalentValue = 0;
                break;
            }
            case XATransaction: {
                containerEquivalentValue = 2;
                break;
            }
            default: {
                containerEquivalentValue = -1;
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("convertSpecTxSupportToContainerTxSupport: passed in mcfTransactionSupport =>" + mcfTS + ", " + "converted container equivalent value: " + containerEquivalentValue);
        }
        return containerEquivalentValue;
    }

    public static int parseTransactionSupportString(String txSupport) {
        int txSupportIntVal = -1;
        if (txSupport == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("txSupport is null");
            }
            return txSupportIntVal;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("parseTransactionSupportString: passed in txSupport =>" + txSupport);
        }
        if ("NoTransaction".equals(txSupport)) {
            txSupportIntVal = 0;
        } else if ("LocalTransaction".equals(txSupport)) {
            txSupportIntVal = 1;
        } else if ("XATransaction".equals(txSupport)) {
            txSupportIntVal = 2;
        }
        return txSupportIntVal;
    }

    public static boolean isTxSupportConfigurationSane(int txSupport, String raName) {
        int raXmlTxSupport = -1;
        try {
            raXmlTxSupport = ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(raName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage() != null ? e.getMessage() : "  ");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "isTxSupportConfigSane:: txSupport => " + txSupport + "  raXmlTxSupport => " + raXmlTxSupport);
        }
        return txSupport <= raXmlTxSupport;
    }

    public static TransactionSupport getTransactionSupport(int ts) {
        switch (ts) {
            case 0: {
                return TransactionSupport.NO_TRANSACTION;
            }
            case 1: {
                return TransactionSupport.LOCAL_TRANSACTION;
            }
            case 2: {
                return TransactionSupport.XA_TRANSACTION;
            }
        }
        return null;
    }

    public static String getValueFromMCF(String prop, PoolInfo poolInfo, ManagedConnectionFactory mcf) {
        String result;
        block2: {
            result = null;
            try {
                Method m = mcf.getClass().getMethod("get" + prop, null);
                result = (String)m.invoke((Object)mcf, (Object[])null);
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, t.getMessage(), t);
            }
        }
        return result == null ? "" : result;
    }

    public static Subject createSubject(ManagedConnectionFactory mcf, final ResourcePrincipal prin) {
        String password;
        final Subject tempSubject = new Subject();
        if (prin != null && (password = prin.getPassword()) != null) {
            final PasswordCredential pc = new PasswordCredential(prin.getName(), password.toCharArray());
            pc.setManagedConnectionFactory(mcf);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tempSubject.getPrincipals().add((Principal)prin);
                    tempSubject.getPrivateCredentials().add(pc);
                    return null;
                }
            });
        }
        return tempSubject;
    }

    public static boolean isPoolSystemPool(com.sun.enterprise.config.serverbeans.ConnectorConnectionPool domainCcp) {
        String poolName = domainCcp.getName();
        return ConnectionPoolObjectsUtils.isPoolSystemPool(poolName);
    }

    public static boolean isPoolSystemPool(String poolName) {
        Pattern pattern = Pattern.compile("#");
        Matcher matcher = pattern.matcher(poolName);
        if (!matcher.find()) {
            return false;
        }
        matcher.reset();
        String moduleNameFromPoolName = null;
        int matchCount = 0;
        while (matcher.find()) {
            ++matchCount;
            int patternStart = matcher.start();
            moduleNameFromPoolName = poolName.substring(0, patternStart);
        }
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        switch (matchCount) {
            case 1: {
                if (!resUtil.belongToStandAloneRar(moduleNameFromPoolName)) break;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setLazyEnlistAndLazyAssocProperties(String lazyAssocString, List<Property> properties, ConnectorConnectionPool conConnPool) {
        if (properties == null) {
            return;
        }
        Property lazyEnlistElement = null;
        for (Property property : properties) {
            if (!property.getName().equalsIgnoreCase("LAZYCONNECTIONENLISTMENT")) continue;
            lazyEnlistElement = property;
        }
        boolean lazyAssoc = ConnectionPoolObjectsUtils.toBoolean(lazyAssocString, false);
        if (lazyEnlistElement != null) {
            boolean lazyEnlist = ConnectionPoolObjectsUtils.toBoolean(lazyEnlistElement.getValue(), false);
            if (!lazyAssoc) {
                conConnPool.setLazyConnectionAssoc(false);
                return;
            }
            if (lazyEnlist) {
                conConnPool.setLazyConnectionAssoc(true);
                conConnPool.setLazyConnectionEnlist(true);
                return;
            }
            _logger.log(Level.SEVERE, "conn_pool_obj_utils.lazy_enlist-lazy_assoc-invalid-combination", conConnPool.getName());
            String i18nMsg = localStrings.getString("cpou.lazy_enlist-lazy_assoc-invalid-combination");
            throw new RuntimeException(i18nMsg + conConnPool.getName());
        }
        if (lazyAssoc) {
            conConnPool.setLazyConnectionAssoc(true);
            conConnPool.setLazyConnectionEnlist(true);
            return;
        }
        conConnPool.setLazyConnectionAssoc(false);
    }

    private static boolean toBoolean(Object prop, boolean defaultVal) {
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf(((String)prop).toLowerCase(Locale.getDefault()));
    }

    public static int getTransactionSupportFromRaXml(String rarName) throws ConnectorRuntimeException {
        String txSupport = ConnectorRuntime.getRuntime().getConnectorDescriptor(rarName).getOutboundResourceAdapter().getTransSupport();
        return ConnectionPoolObjectsUtils.parseTransactionSupportString(txSupport);
    }
}

