/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebBeanDiscoveryImpl
implements WebBeanDiscovery {
    private Logger logger = Logger.getLogger(WebBeanDiscoveryImpl.class.getName());
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar";
    private static final String SEPERATOR_CHAR = "/";
    private final List<Class<?>> wbClasses = new ArrayList();
    private final List<URL> wbUrls = new ArrayList<URL>();
    private final ReadableArchive archive;

    public WebBeanDiscoveryImpl(ReadableArchive archive) {
        this.archive = archive;
        this.scan();
    }

    @Override
    public Iterable<Class<?>> discoverWebBeanClasses() {
        return Collections.unmodifiableList(this.wbClasses);
    }

    @Override
    public Iterable<URL> discoverWebBeansXml() {
        return Collections.unmodifiableList(this.wbUrls);
    }

    private void scan() {
        try {
            URL beansXmlUrl;
            String entry;
            Enumeration entries;
            if (this.archive.exists(WEB_INF_BEANS_XML)) {
                entries = this.archive.entries();
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    if (entry.endsWith(CLASS_SUFFIX)) {
                        entry = entry.substring(WEB_INF_CLASSES.length() + 1);
                        String className = WebBeanDiscoveryImpl.filenameToClassname(entry);
                        this.wbClasses.add(this.getClassLoader().loadClass(className));
                        continue;
                    }
                    if (!entry.endsWith("beans.xml")) continue;
                    URI uri = this.archive.getURI();
                    File file = new File(uri.getPath() + entry);
                    beansXmlUrl = file.toURL();
                    this.wbUrls.add(beansXmlUrl);
                }
                this.archive.close();
            }
            if (this.archive.exists(WEB_INF_LIB)) {
                entries = this.archive.entries(WEB_INF_LIB);
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    if (!entry.endsWith(JAR_SUFFIX) || entry.indexOf(SEPERATOR_CHAR, WEB_INF_LIB.length() + 1) != -1) continue;
                    ReadableArchive jarArchive = this.archive.getSubArchive(entry);
                    if (jarArchive.exists(META_INF_BEANS_XML)) {
                        Enumeration jarEntries = jarArchive.entries();
                        while (jarEntries.hasMoreElements()) {
                            entry = (String)entries.nextElement();
                            if (entry.endsWith(CLASS_SUFFIX)) {
                                String className = WebBeanDiscoveryImpl.filenameToClassname(entry);
                                this.wbClasses.add(this.getClassLoader().loadClass(className));
                                continue;
                            }
                            if (!entry.endsWith("beans.xml")) continue;
                            beansXmlUrl = WebBeanDiscoveryImpl.class.getResource(entry);
                            this.wbUrls.add(beansXmlUrl);
                        }
                    }
                    jarArchive.close();
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException cne) {
            this.logger.log(Level.SEVERE, cne.getLocalizedMessage(), cne);
        }
    }

    public static String filenameToClassname(String filename) {
        String className = filename.replace(File.separatorChar, '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private ClassLoader getClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return WebBeanDiscoveryImpl.class.getClassLoader();
    }
}

