/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.util.proxy.ProxyFactory;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxies {
    public static ProxyFactory getProxyFactory(Set<Type> types) {
        return TypeInfo.ofTypes(types).createProxyFactory();
    }

    public static boolean isTypeProxyable(Type type) {
        Type rawType;
        if (type instanceof Class) {
            return Proxies.isClassProxyable((Class)type);
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return Proxies.isClassProxyable((Class)rawType);
        }
        return false;
    }

    public static boolean isTypesProxyable(Iterable<? extends Type> types) {
        for (Type type : types) {
            if (Object.class.equals((Object)type) || Proxies.isTypeProxyable(type)) continue;
            return false;
        }
        return true;
    }

    private static boolean isClassProxyable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return true;
        }
        Constructor<?> constructor = Reflections.getDeclaredConstructor(clazz, new Class[0]);
        if (constructor == null) {
            return false;
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            return false;
        }
        if (Reflections.isTypeOrAnyMethodFinal(clazz)) {
            return false;
        }
        if (Reflections.isPrimitive(clazz)) {
            return false;
        }
        return !Reflections.isArrayType(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeInfo {
        private static final Class<?>[] EMPTY_INTERFACES_ARRAY = new Class[0];
        private final Set<Class<?>> interfaces = new LinkedHashSet();
        private final Set<Class<?>> classes = new LinkedHashSet();

        private TypeInfo() {
        }

        public Class<?> getSuperClass() {
            if (this.classes.isEmpty()) {
                return null;
            }
            Iterator<Class<?>> it = this.classes.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        private Class<?>[] getInterfaces() {
            return this.interfaces.toArray(EMPTY_INTERFACES_ARRAY);
        }

        public ProxyFactory createProxyFactory() {
            ProxyFactory proxyFactory = new ProxyFactory();
            Class<?> superClass = this.getSuperClass();
            if (superClass != null && superClass != Object.class) {
                proxyFactory.setSuperclass(superClass);
            }
            proxyFactory.setInterfaces(this.getInterfaces());
            return proxyFactory;
        }

        private void add(Type type) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (clazz.isInterface()) {
                    this.interfaces.add(clazz);
                } else {
                    this.classes.add(clazz);
                }
            } else if (type instanceof ParameterizedType) {
                this.add(((ParameterizedType)type).getRawType());
            } else {
                throw new IllegalArgumentException("Cannot proxy non-Class Type " + type);
            }
        }

        public static TypeInfo ofTypes(Set<? extends Type> types) {
            TypeInfo typeInfo = new TypeInfo();
            for (Type type : types) {
                typeInfo.add(type);
            }
            return typeInfo;
        }

        public static TypeInfo ofClasses(Set<Class<?>> classes) {
            TypeInfo typeInfo = new TypeInfo();
            for (Class<?> type : classes) {
                typeInfo.add(type);
            }
            return typeInfo;
        }
    }
}

