/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.context.ScopeType;
import javax.inject.DefinitionException;
import javax.inject.DeploymentType;
import javax.inject.IllegalProductException;
import javax.inject.Initializer;
import javax.inject.Produces;
import javax.inject.manager.InjectionPoint;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.context.CreationalContextImpl;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.DependentStorageRequest;
import org.jboss.webbeans.introspector.AnnotatedMember;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProducerBean<T, S extends Member>
extends AbstractBean<T, S> {
    protected AbstractClassBean<?> declaringBean;
    private static final LogProvider log = Logging.getLogProvider(AbstractProducerBean.class);

    public AbstractProducerBean(AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        super(manager);
        this.declaringBean = declaringBean;
    }

    @Override
    protected abstract AnnotatedMember<T, S> getAnnotatedItem();

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        this.deploymentType = this.declaringBean.getDeploymentType();
        return this.deploymentType;
    }

    @Override
    protected void initTypes() {
        if (this.getType().isArray() || this.getType().isPrimitive()) {
            HashSet<? extends Type> types = new HashSet<Type>();
            types = new HashSet();
            types.add(this.getType());
            types.add((Type)((Object)Object.class));
            this.types = types;
        } else if (this.getType().isInterface()) {
            HashSet<? extends Type> types = new HashSet<Type>();
            types.add((Type)((Object)Object.class));
            types.addAll(this.getAnnotatedItem().getFlattenedTypeHierarchy());
            this.types = types;
        } else {
            super.initTypes();
        }
    }

    protected void initType() {
        try {
            this.type = this.getAnnotatedItem().getRawType();
        }
        catch (ClassCastException e) {
            throw new RuntimeException(" Cannot cast producer type " + this.getAnnotatedItem().getRawType() + " to bean type " + (this.getDeclaredBeanType() == null ? " unknown " : this.getDeclaredBeanType()), e);
        }
    }

    protected Type getDeclaredBeanType() {
        ParameterizedType parameterizedType;
        Class<?> type = this.getClass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)((Object)type)).getActualTypeArguments().length == 1) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    public AbstractClassBean<?> getDeclaringBean() {
        return this.declaringBean;
    }

    protected void checkProducerReturnType() {
        if (this.getAnnotatedItem().getType() instanceof TypeVariable) {
            throw new DefinitionException("Return type must be concrete " + this.getAnnotatedItem().getType());
        }
        if (this.getAnnotatedItem().getType() instanceof WildcardType) {
            throw new DefinitionException("Return type must be concrete " + this.getAnnotatedItem().getType());
        }
        for (Type type : this.getAnnotatedItem().getActualTypeArguments()) {
            if (type instanceof Class) continue;
            throw new DefinitionException("Producer type cannot be parameterized with type parameter or wildcard:\n" + this.getAnnotatedItem());
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.declaringBean.initialize(environment);
        super.initialize(environment);
        this.checkProducerReturnType();
    }

    protected void checkReturnValue(T instance) {
        if (instance == null && !this.isDependent()) {
            throw new IllegalProductException("Cannot return null from a non-dependent producer method");
        }
        boolean passivating = this.manager.getServices().get(MetaDataCache.class).getScopeModel(this.getScopeType()).isPassivating();
        if (passivating && !Reflections.isSerializable(instance.getClass())) {
            throw new IllegalProductException("Producers cannot declare passivating scope and return a non-serializable class");
        }
        InjectionPoint injectionPoint = this.manager.getInjectionPoint();
        if (injectionPoint == null) {
            return;
        }
        if (this.isDependent() && Beans.isPassivatingBean(injectionPoint.getBean(), this.manager)) {
            if (injectionPoint.getMember() instanceof Field) {
                if (!Reflections.isTransient(injectionPoint.getMember()) && !Reflections.isSerializable(instance.getClass())) {
                    throw new IllegalProductException("Dependent scoped producers cannot produce non-serializable instances for injection into non-transient fields of passivating beans\n\nProducer: " + this.toString() + "\nInjection Point: " + injectionPoint.toString());
                }
            } else if (injectionPoint.getMember() instanceof Method) {
                Method method = (Method)injectionPoint.getMember();
                if (method.isAnnotationPresent(Initializer.class)) {
                    throw new IllegalProductException("Dependent scoped producers cannot produce non-serializable instances for injection into parameters of intializers of beans declaring passivating scope. Bean " + this.toString() + " being injected into " + injectionPoint.toString());
                }
                if (method.isAnnotationPresent(Produces.class)) {
                    throw new IllegalProductException("Dependent scoped producers cannot produce non-serializable instances for injection into parameters of producer methods declaring passivating scope. Bean " + this.toString() + " being injected into " + injectionPoint.toString());
                }
            } else if (injectionPoint.getMember() instanceof Constructor) {
                throw new IllegalProductException("Dependent scoped producers cannot produce non-serializable instances for injection into parameters of constructors of beans declaring passivating scope. Bean " + this.toString() + " being injected into " + injectionPoint.toString());
            }
        }
    }

    @Override
    protected void initScopeType() {
        Set<Annotation> scopeAnnotations = this.getAnnotatedItem().getMetaAnnotations(ScopeType.class);
        if (scopeAnnotations.size() > 1) {
            throw new DefinitionException("At most one scope may be specified");
        }
        if (scopeAnnotations.size() == 1) {
            this.scopeType = scopeAnnotations.iterator().next().annotationType();
            log.trace("Scope " + this.scopeType + " specified by annotation");
            return;
        }
        this.initScopeTypeFromStereotype();
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace("Using default @Dependent scope");
        }
    }

    @Override
    protected void initDeploymentType() {
        Set<Annotation> deploymentTypes = this.getAnnotatedItem().getMetaAnnotations(DeploymentType.class);
        if (deploymentTypes.size() > 1) {
            throw new DefinitionException("At most one deployment type may be specified (" + deploymentTypes + " are specified) on " + this.getAnnotatedItem().toString());
        }
        if (deploymentTypes.size() == 1) {
            this.deploymentType = deploymentTypes.iterator().next().annotationType();
            log.trace("Deployment type " + this.deploymentType + " specified by annotation");
            return;
        }
        this.initDeploymentTypeFromStereotype();
        if (this.deploymentType == null) {
            this.deploymentType = this.getDefaultDeploymentType();
            log.trace("Using default " + this.deploymentType + " deployment type");
            return;
        }
    }

    @Override
    protected void initSerializable() {
        this._serializable = true;
    }

    protected Object getReceiver(CreationalContext<?> creationalContext) {
        CreationalContextImpl creationalContextImpl;
        if (this.getAnnotatedItem().isStatic()) {
            return null;
        }
        if (creationalContext instanceof CreationalContextImpl && (creationalContextImpl = (CreationalContextImpl)creationalContext).containsIncompleteInstance(this.getDeclaringBean())) {
            log.warn("Executing producer field or method " + this.getAnnotatedItem() + " on incomplete declaring bean " + this.getDeclaringBean() + " due to circular injection");
            return creationalContextImpl.getIncompleteInstance(this.getDeclaringBean());
        }
        return this.manager.getInstance(this.getDeclaringBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(CreationalContext<T> creationalContext) {
        DependentStorageRequest dependentStorageRequest = DependentStorageRequest.of(this.dependentInstancesStore, new Object());
        try {
            if (this.getDeclaringBean().isDependent()) {
                DependentContext.instance().startCollectingDependents(dependentStorageRequest);
            }
            DependentContext.instance().setActive(true);
            T instance = this.produceInstance(creationalContext);
            this.checkReturnValue(instance);
            T t = instance;
            return t;
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                DependentContext.instance().stopCollectingDependents(dependentStorageRequest);
                this.dependentInstancesStore.destroyDependentInstances(dependentStorageRequest.getKey());
            }
            DependentContext.instance().setActive(false);
        }
    }

    @Override
    public void destroy(T instance) {
    }

    protected abstract T produceInstance(CreationalContext<T> var1);

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Annotated " + Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed producer bean");
        } else {
            buffer.append("simple producer bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "] API types " + this.getTypes() + ", binding types " + this.getBindings());
        return buffer.toString();
    }
}

