/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.ee.AbstractJavaEEResourceBean;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.introspector.AnnotatedAnnotation;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.resources.spi.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEnvironment {
    private final List<AnnotatedClass<?>> classes = new ArrayList();
    private final List<AnnotatedAnnotation<?>> annotations = new ArrayList();
    private final ServiceRegistry serviceRegistry;
    private final List<Class<? extends Annotation>> enabledDeploymentTypes = new ArrayList<Class<? extends Annotation>>();
    private final Iterable<URL> beansXmlUrls;
    private final EjbDescriptorCache ejbDescriptors;
    private final Set<AbstractJavaEEResourceBean<?>> resourceBeans = new HashSet();
    private final ManagerImpl manager;

    public XmlEnvironment(ServiceRegistry serviceRegistry, EjbDescriptorCache ejbDescriptors, ManagerImpl manager) {
        this(serviceRegistry, serviceRegistry.get(WebBeanDiscovery.class).discoverWebBeansXml(), ejbDescriptors, manager);
    }

    protected XmlEnvironment(ServiceRegistry serviceRegistry, Iterable<URL> beanXmlUrls, EjbDescriptorCache ejbDescriptors, ManagerImpl manager) {
        this.serviceRegistry = serviceRegistry;
        this.beansXmlUrls = beanXmlUrls;
        this.ejbDescriptors = ejbDescriptors;
        this.manager = manager;
    }

    public List<AnnotatedClass<?>> getClasses() {
        return this.classes;
    }

    public List<AnnotatedAnnotation<?>> getAnnotations() {
        return this.annotations;
    }

    public Iterable<URL> getBeansXmlUrls() {
        return this.beansXmlUrls;
    }

    public <T> AnnotatedClass<? extends T> loadClass(String className, Class<T> expectedType) {
        return this.serviceRegistry.get(ClassTransformer.class).classForName(this.serviceRegistry.get(ResourceLoader.class).classForName(className).asSubclass(expectedType));
    }

    public <T extends Annotation> Class<? extends T> loadAnnotation(String className, Class<T> expectedType) {
        return this.serviceRegistry.get(ResourceLoader.class).classForName(className).asSubclass(expectedType);
    }

    public List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        return this.enabledDeploymentTypes;
    }

    public EjbDescriptorCache getEjbDescriptors() {
        return this.ejbDescriptors;
    }

    public URL loadFileByUrn(String urn, String fileName) {
        char separator = '/';
        String packageName = urn.replaceFirst("urn:java:", "");
        String path = packageName.replace('.', separator);
        String filePath = path + separator + fileName;
        return this.serviceRegistry.get(ResourceLoader.class).getResource(filePath);
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public Set<AbstractJavaEEResourceBean<?>> getResourceBeans() {
        return this.resourceBeans;
    }

    public ManagerImpl getManager() {
        return this.manager;
    }
}

