/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans;

import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.util.Collection;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.webbeans.WebBeanDiscoveryImpl;
import org.glassfish.webbeans.WebBeansApplicationContainer;
import org.glassfish.webbeans.WebBeansContainer;
import org.jboss.webbeans.bootstrap.WebBeansBootstrap;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebBeansDeployer
extends SimpleDeployer<WebBeansContainer, WebBeansApplicationContainer> {
    private static final String WEB_BEAN_EXTENSION = "org.glassfish.webbeans";
    private static final String WEB_BEAN_LISTENER = "org.jboss.webbeans.servlet.WebBeansListener";
    @Inject
    private Habitat habitat;

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public boolean prepare(DeploymentContext context) {
        return true;
    }

    public WebBeansApplicationContainer load(WebBeansContainer container, DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        ConcurrentHashMapBeanStore applicationBeanStore = new ConcurrentHashMapBeanStore();
        WebBeansBootstrap bootstrap = new WebBeansBootstrap();
        bootstrap.setEnvironment(Environments.SERVLET);
        bootstrap.getServices().add(WebBeanDiscovery.class, new WebBeanDiscoveryImpl(archive){});
        bootstrap.setApplicationContext(applicationBeanStore);
        WebBundleDescriptor wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class);
        if (wDesc != null) {
            wDesc.setExtensionProperty(WEB_BEAN_EXTENSION, "true");
            wDesc.addAppListenerDescriptor(new AppListenerDescriptorImpl(WEB_BEAN_LISTENER));
        }
        WebBeansApplicationContainer wbApp = new WebBeansApplicationContainer(bootstrap);
        bootstrap.initialize();
        return wbApp;
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        WebBundleDescriptor wDesc;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null && (wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class)) != null) {
            Collection ejbBundles = wDesc.getExtensionsDescriptors(EjbBundleDescriptor.class);
            ejbBundle = (EjbBundleDescriptor)ejbBundles.iterator().next();
        }
        return ejbBundle;
    }
}

