/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.inject.spi.Bean;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.api.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanIdStore
implements Service {
    private final BiMap<Integer, BeanHolder<?>> beans;
    private final AtomicInteger idGenerator = new AtomicInteger(0);

    public BeanIdStore() {
        this.beans = HashBiMap.create();
    }

    public <T> Bean<T> get(Integer id) {
        return ((BeanHolder)this.beans.get(id)).getBean();
    }

    public boolean contains(Integer id) {
        return this.beans.containsKey(id);
    }

    public Integer put(Bean<?> bean, BeanManagerImpl manager) {
        if (this.beans.inverse().containsKey(bean)) {
            return (Integer)this.beans.inverse().get(bean);
        }
        Integer id = this.idGenerator.incrementAndGet();
        this.beans.put(id, BeanHolder.of(bean, manager));
        return id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanHolder<T> {
        private final Bean<T> bean;
        private final BeanManagerImpl manager;

        public static <T> BeanHolder<T> of(Bean<T> bean, BeanManagerImpl manager) {
            return new BeanHolder<T>(bean, manager);
        }

        public BeanHolder(Bean<T> bean, BeanManagerImpl manager) {
            this.bean = bean;
            this.manager = manager;
        }

        public Bean<T> getBean() {
            return this.bean;
        }

        public BeanManagerImpl getManager() {
            return this.manager;
        }

        public int hashCode() {
            return this.bean.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BeanHolder) {
                return this.bean.equals(((BeanHolder)obj).getBean());
            }
            return false;
        }
    }
}

