/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.decorator.Decorates;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.BindingType;
import javax.enterprise.inject.Named;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.deployment.Standard;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.stereotype.Stereotype;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.literal.AnyLiteral;
import org.jboss.webbeans.literal.CurrentLiteral;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.cache.MergedStereotypes;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T, E>
extends RIBean<T> {
    private static final Annotation ANY_LITERAL = new AnyLiteral();
    private static final Annotation CURRENT_LITERAL = new CurrentLiteral();
    private static Set<Class<?>> STANDARD_WEB_BEAN_CLASSES = new HashSet<Class>(Arrays.asList(Event.class, BeanManagerImpl.class, ConversationImpl.class));
    private boolean proxyable;
    private final Log log = Logging.getLog(AbstractBean.class);
    protected Set<Annotation> bindings;
    protected String name;
    protected Class<? extends Annotation> scopeType;
    private MergedStereotypes<T, E> mergedStereotypes;
    protected Class<? extends Annotation> deploymentType;
    protected Class<T> type;
    protected Set<Type> types;
    protected Set<WBInjectionPoint<?, ?>> injectionPoints;
    private boolean primitive;
    protected BeanManagerImpl manager;
    protected boolean _serializable;
    private boolean initialized;
    private Set<WBInjectionPoint<?, ?>> decoratesInjectionPoint;

    public static Class<? extends Annotation> getDeploymentType(List<Class<? extends Annotation>> enabledDeploymentTypes, Map<Class<? extends Annotation>, Annotation> possibleDeploymentTypes) {
        for (int i = enabledDeploymentTypes.size() - 1; i > 0; --i) {
            if (!possibleDeploymentTypes.containsKey(enabledDeploymentTypes.get(i))) continue;
            return enabledDeploymentTypes.get(i);
        }
        return null;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public AbstractBean(BeanManagerImpl manager) {
        super(manager);
        this.manager = manager;
        this.injectionPoints = new HashSet();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.mergedStereotypes = new MergedStereotypes(this.getAnnotatedItem().getMetaAnnotations(Stereotype.class), this.manager);
        if (this.isSpecializing()) {
            this.preSpecialize(environment);
            this.specialize(environment);
            this.postSpecialize();
        }
        this.initDefaultBindings();
        this.initPrimitive();
        this.log.trace((Object)"Building Web Bean bean metadata for #0", this.getType());
        this.initName();
        this.initDeploymentType();
        this.checkDeploymentType();
        this.initScopeType();
        this.initSerializable();
        this.initProxyable();
        this.initInjectionPoints();
        this.initDecorates();
        this.checkDecorates();
    }

    protected void checkDecorates() {
        if (this.decoratesInjectionPoint.size() > 0) {
            throw new DefinitionException("Cannot place @Decorates at an injection point which is not on a Decorator " + this);
        }
    }

    protected void initDecorates() {
        this.decoratesInjectionPoint = new HashSet();
        for (WBInjectionPoint<?, ?> injectionPoint : this.getAnnotatedInjectionPoints()) {
            if (!injectionPoint.isAnnotationPresent(Decorates.class)) continue;
            this.decoratesInjectionPoint.add(injectionPoint);
        }
    }

    protected Set<WBInjectionPoint<?, ?>> getDecoratesInjectionPoint() {
        return this.decoratesInjectionPoint;
    }

    protected void initTypes() {
        this.types = this.getAnnotatedItem().getTypeClosure();
    }

    protected void initBindings() {
        this.bindings = new HashSet<Annotation>();
        this.bindings.addAll(this.getAnnotatedItem().getMetaAnnotations(BindingType.class));
        this.initDefaultBindings();
        this.log.trace((Object)("Using binding types " + this.bindings + " specified by annotations"), new Object[0]);
    }

    protected abstract void initInjectionPoints();

    protected void initDefaultBindings() {
        if (this.bindings.size() == 0) {
            this.log.trace((Object)"Adding default @Current binding type", new Object[0]);
            this.bindings.add(CURRENT_LITERAL);
        }
        this.bindings.add(ANY_LITERAL);
    }

    protected abstract void initDeploymentType();

    protected void initDeploymentTypeFromStereotype() {
        Map<Class<? extends Annotation>, Annotation> possibleDeploymentTypes = this.getMergedStereotypes().getPossibleDeploymentTypes();
        if (possibleDeploymentTypes.size() > 0) {
            this.deploymentType = AbstractBean.getDeploymentType(this.manager.getEnabledDeploymentTypes(), possibleDeploymentTypes);
            this.log.trace((Object)"Deployment type #0 specified by stereotype", this.deploymentType);
            return;
        }
    }

    protected abstract Class<? extends Annotation> getDefaultDeploymentType();

    protected void initName() {
        boolean beanNameDefaulted = false;
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class)) {
            String javaName = this.getAnnotatedItem().getAnnotation(Named.class).value();
            if ("".equals(javaName)) {
                this.log.trace((Object)"Using default name (specified by annotations)", new Object[0]);
                beanNameDefaulted = true;
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Using name " + javaName + " specified by annotations"), new Object[0]);
                }
                this.name = javaName;
                return;
            }
        }
        if (beanNameDefaulted || this.getMergedStereotypes().isBeanNameDefaulted()) {
            this.name = this.getDefaultName();
            return;
        }
    }

    protected void initProxyable() {
        this.proxyable = this.getAnnotatedItem().isProxyable();
    }

    protected void initPrimitive() {
        this.primitive = Reflections.isPrimitive(this.getType());
    }

    private boolean checkInjectionPointsAreSerializable() {
        boolean passivating = this.manager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScopeType()).isPassivating();
        for (WBInjectionPoint<?, ?> injectionPoint : this.getAnnotatedInjectionPoints()) {
            Annotation[] bindings = injectionPoint.getMetaAnnotationsAsArray(BindingType.class);
            Bean<?> resolvedBean = this.manager.getBeans(injectionPoint.getJavaClass(), bindings).iterator().next();
            if (!passivating || !Dependent.class.equals(resolvedBean.getScopeType()) || resolvedBean.isSerializable() || (!(injectionPoint instanceof WBField) || ((WBField)((Object)injectionPoint)).isTransient()) && !(injectionPoint instanceof WBParameter)) continue;
            return false;
        }
        return true;
    }

    protected abstract void initScopeType();

    protected boolean initScopeTypeFromStereotype() {
        Set<Annotation> possibleScopeTypes = this.getMergedStereotypes().getPossibleScopeTypes();
        if (possibleScopeTypes.size() == 1) {
            this.scopeType = possibleScopeTypes.iterator().next().annotationType();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Scope " + this.scopeType + " specified by stereotype"), new Object[0]);
            }
            return true;
        }
        if (possibleScopeTypes.size() > 1) {
            throw new DefinitionException("All stereotypes must specify the same scope OR a scope must be specified on " + this.getAnnotatedItem());
        }
        return false;
    }

    protected void checkDeploymentType() {
        if (this.deploymentType == null) {
            throw new DefinitionException("type: " + this.getType() + " must specify a deployment type");
        }
        if (this.deploymentType.equals(Standard.class) && !STANDARD_WEB_BEAN_CLASSES.contains(this.getAnnotatedItem().getJavaClass())) {
            throw new DefinitionException(this.getAnnotatedItem().getName() + " cannot have deployment type @Standard");
        }
    }

    protected void postSpecialize() {
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class) && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            throw new DefinitionException("Cannot put name on specializing and specialized class " + this.getAnnotatedItem());
        }
        this.bindings.addAll(((AbstractBean)this.getSpecializedBean()).getBindings());
        if (this.isSpecializing() && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            this.name = ((AbstractBean)this.getSpecializedBean()).getName();
            return;
        }
        this.manager.getSpecializedBeans().put(this.getSpecializedBean(), this);
    }

    protected void preSpecialize(BeanDeployerEnvironment environment) {
    }

    protected void specialize(BeanDeployerEnvironment environment) {
    }

    protected abstract WBAnnotated<T, E> getAnnotatedItem();

    @Override
    public Set<Annotation> getBindings() {
        return this.bindings;
    }

    protected abstract String getDefaultName();

    public abstract AbstractBean<?, ?> getSpecializedBean();

    @Override
    public Class<? extends Annotation> getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public Set<WBInjectionPoint<?, ?>> getAnnotatedInjectionPoints() {
        return this.injectionPoints;
    }

    protected MergedStereotypes<T, E> getMergedStereotypes() {
        return this.mergedStereotypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends Annotation> getScopeType() {
        return this.scopeType;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isAssignableFrom(WBAnnotated<?, ?> annotatedItem) {
        return this.getAnnotatedItem().isAssignableFrom(annotatedItem);
    }

    @Override
    public boolean isNullable() {
        return !this.isPrimitive();
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    public boolean isSerializable() {
        return this._serializable && this.checkInjectionPointsAreSerializable();
    }

    protected void initSerializable() {
        this._serializable = Reflections.isSerializable(this.type);
    }

    public String toString() {
        return "AbstractBean " + this.getName();
    }

    @Override
    public boolean isProxyable() {
        return this.proxyable;
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.getScopeType());
    }

    @Override
    public boolean isSpecializing() {
        return this.getAnnotatedItem().isAnnotationPresent(Specializes.class);
    }
}

