/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.WBInjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RIBean<T>
implements Bean<T> {
    private static final ConcurrentMap<String, AtomicInteger> ids = new ConcurrentHashMap<String, AtomicInteger>();
    private final BeanManagerImpl manager;

    protected RIBean(BeanManagerImpl manager) {
        this.manager = manager;
    }

    protected static String createId(String prefix) {
        AtomicInteger i = ids.putIfAbsent(prefix, new AtomicInteger());
        return prefix + "-" + i;
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    public abstract Class<T> getType();

    public abstract void initialize(BeanDeployerEnvironment var1);

    public abstract boolean isSpecializing();

    public boolean isDependent() {
        return this.getScopeType().equals(Dependent.class);
    }

    public abstract boolean isProxyable();

    public abstract boolean isPrimitive();

    public abstract Set<WBInjectionPoint<?, ?>> getAnnotatedInjectionPoints();

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getAnnotatedInjectionPoints();
    }

    public abstract RIBean<?> getSpecializedBean();

    public abstract String getId();

    public boolean equals(Object obj) {
        if (obj instanceof RIBean) {
            RIBean that = (RIBean)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

