/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bootstrap.AbstractBeanDeployer;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployer
extends AbstractBeanDeployer {
    private final Set<WBClass<?>> classes = new HashSet();

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptorCache ejbDescriptors) {
        super(manager, new BeanDeployerEnvironment(ejbDescriptors, manager));
    }

    public AbstractBeanDeployer addBeans(Iterable<? extends RIBean<?>> beans) {
        for (RIBean<?> bean : beans) {
            this.addBean(bean);
        }
        return this;
    }

    public AbstractBeanDeployer addClass(Class<?> clazz) {
        ClassTransformer classTransformer = this.getManager().getServices().get(ClassTransformer.class);
        if (!clazz.isAnnotation() && !clazz.isEnum()) {
            this.classes.add(classTransformer.loadClass(clazz));
        }
        return this;
    }

    public AbstractBeanDeployer addClass(AnnotatedType<?> clazz) {
        ClassTransformer classTransformer = this.getManager().getServices().get(ClassTransformer.class);
        if (!clazz.getJavaClass().isAnnotation() && !clazz.getJavaClass().isEnum()) {
            this.classes.add(classTransformer.loadClass(clazz));
        }
        return this;
    }

    public AbstractBeanDeployer addClasses(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.addClass(clazz);
        }
        return this;
    }

    public AbstractBeanDeployer addClasses(Collection<WBClass<?>> classes) {
        classes.addAll(classes);
        return this;
    }

    public AbstractBeanDeployer createBeans() {
        for (WBClass<?> clazz : this.classes) {
            if (this.getBeanDeployerEnvironment().getEjbDescriptors().containsKey(clazz.getJavaClass())) {
                this.createEnterpriseBean(clazz);
                continue;
            }
            boolean managedBeanOrDecorator = this.isTypeManagedBeanOrDecorator(clazz);
            if (managedBeanOrDecorator && clazz.isAnnotationPresent(Decorator.class)) {
                this.createDecorator(clazz);
                continue;
            }
            if (!managedBeanOrDecorator || clazz.isAbstract()) continue;
            this.createSimpleBean(clazz);
        }
        return this;
    }
}

