/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.inject.spi.Extension;
import org.jboss.webbeans.BeanIdStore;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.DeploymentException;
import org.jboss.webbeans.Validator;
import org.jboss.webbeans.bean.standard.EventBean;
import org.jboss.webbeans.bean.standard.InjectionPointBean;
import org.jboss.webbeans.bean.standard.InstanceBean;
import org.jboss.webbeans.bean.standard.ManagerBean;
import org.jboss.webbeans.bootstrap.AfterBeanDiscoveryImpl;
import org.jboss.webbeans.bootstrap.AfterDeploymentValidationImpl;
import org.jboss.webbeans.bootstrap.BeanDeployer;
import org.jboss.webbeans.bootstrap.BeforeBeanDiscoveryImpl;
import org.jboss.webbeans.bootstrap.BeforeShutdownImpl;
import org.jboss.webbeans.bootstrap.ExtensionBeanDeployer;
import org.jboss.webbeans.bootstrap.api.Bootstrap;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.api.helpers.AbstractBootstrap;
import org.jboss.webbeans.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.webbeans.bootstrap.spi.Deployment;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.ContextLifecycle;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.conversation.JavaSEConversationTerminator;
import org.jboss.webbeans.conversation.NumericConversationIdGenerator;
import org.jboss.webbeans.conversation.ServletConversationManager;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.jsf.JsfApiAbstraction;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.messaging.spi.JmsServices;
import org.jboss.webbeans.metadata.TypeStore;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.persistence.PersistenceApiAbstraction;
import org.jboss.webbeans.persistence.spi.JpaServices;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.resources.DefaultResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceServices;
import org.jboss.webbeans.servlet.HttpSessionManager;
import org.jboss.webbeans.servlet.ServletApiAbstraction;
import org.jboss.webbeans.transaction.spi.TransactionServices;
import org.jboss.webbeans.util.serviceProvider.ServiceLoader;
import org.jboss.webbeans.ws.spi.WebServices;
import org.jboss.webbeans.xml.BeansXmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansBootstrap
extends AbstractBootstrap
implements Bootstrap {
    private static Log log = Logging.getLog(WebBeansBootstrap.class);
    private BeanManagerImpl manager;

    public WebBeansBootstrap() {
        this.getServices().add(ResourceLoader.class, new DefaultResourceLoader());
    }

    @Override
    public void initialize() {
        this.verify();
        if (!this.getServices().contains(TransactionServices.class)) {
            log.info((Object)"Transactional services not available.  Transactional observers will be invoked synchronously.", new Object[0]);
        }
        if (!this.getServices().contains(EjbServices.class)) {
            log.info((Object)"EJB services not available. Session beans will be simple beans, CDI-style injection into non-contextual EJBs, injection of remote EJBs and injection of @EJB in simple beans will not be available", new Object[0]);
        }
        if (!this.getServices().contains(JmsServices.class)) {
            log.info((Object)"JMS services not available. JMS resources will not be available.", new Object[0]);
        }
        if (!this.getServices().contains(JpaServices.class)) {
            log.info((Object)"JPA services not available. Injection of @PersistenceContext will not occur. Entity beans will be discovered as simple beans.", new Object[0]);
        }
        if (!this.getServices().contains(ResourceServices.class)) {
            log.info((Object)"@Resource injection not available.", new Object[0]);
        }
        if (!this.getServices().contains(WebServices.class)) {
            log.info((Object)"WebService reference injection not available.", new Object[0]);
        }
        this.addImplementationServices();
        this.createContexts();
        this.manager = BeanManagerImpl.newRootManager(ServiceRegistries.unmodifiableServiceRegistry(this.getServices()));
        CurrentManager.setRootManager(this.manager);
        this.initializeContexts();
    }

    private void addImplementationServices() {
        ResourceLoader resourceLoader = this.getServices().get(ResourceLoader.class);
        this.getServices().add(EJBApiAbstraction.class, new EJBApiAbstraction(resourceLoader));
        this.getServices().add(JsfApiAbstraction.class, new JsfApiAbstraction(resourceLoader));
        this.getServices().add(PersistenceApiAbstraction.class, new PersistenceApiAbstraction(resourceLoader));
        this.getServices().add(ServletApiAbstraction.class, new ServletApiAbstraction(resourceLoader));
        this.getServices().add(Validator.class, new Validator());
        this.getServices().add(TypeStore.class, new TypeStore());
        this.getServices().add(ClassTransformer.class, new ClassTransformer(this.getServices().get(TypeStore.class)));
        this.getServices().add(MetaAnnotationStore.class, new MetaAnnotationStore(this.getServices().get(ClassTransformer.class)));
        this.getServices().add(BeanIdStore.class, new BeanIdStore());
    }

    @Override
    public BeanManagerImpl getManager() {
        return this.manager;
    }

    protected void registerBeans(Iterable<Class<?>> classes, BeanDeployer beanDeployer) {
        beanDeployer.addClasses(classes);
        beanDeployer.addBean(ManagerBean.of(this.manager));
        beanDeployer.addBean(InjectionPointBean.of(this.manager));
        beanDeployer.addBean(EventBean.of(this.manager));
        beanDeployer.addBean(InstanceBean.of(this.manager));
        if (!this.getEnvironment().equals(Environments.SE)) {
            beanDeployer.addClass(ConversationImpl.class);
            beanDeployer.addClass(ServletConversationManager.class);
            beanDeployer.addClass(JavaSEConversationTerminator.class);
            beanDeployer.addClass(NumericConversationIdGenerator.class);
            beanDeployer.addClass(HttpSessionManager.class);
        }
        beanDeployer.createBeans().deploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boot() {
        WebBeansBootstrap webBeansBootstrap = this;
        synchronized (webBeansBootstrap) {
            if (this.manager == null) {
                throw new IllegalStateException("Manager has not been initialized");
            }
            if (this.getApplicationContext() == null) {
                throw new IllegalStateException("No application context BeanStore set");
            }
            DeploymentVisitor deploymentVisitor = new DeploymentVisitor(this.getServices().get(Deployment.class)).visit();
            this.parseBeansXml(deploymentVisitor.getBeansXmlUrls());
            this.beginApplication(this.getApplicationContext());
            ConcurrentHashMapBeanStore requestBeanStore = new ConcurrentHashMapBeanStore();
            this.beginDeploy(requestBeanStore);
            EjbDescriptorCache ejbDescriptors = new EjbDescriptorCache();
            if (this.getServices().contains(EjbServices.class)) {
                ejbDescriptors.addAll(deploymentVisitor.getEjbDescriptors());
            }
            ExtensionBeanDeployer extensionBeanDeployer = new ExtensionBeanDeployer(this.manager);
            extensionBeanDeployer.addExtensions(ServiceLoader.load(Extension.class));
            extensionBeanDeployer.createBeans().deploy();
            BeanDeployer beanDeployer = new BeanDeployer(this.manager, ejbDescriptors);
            this.fireBeforeBeanDiscoveryEvent(beanDeployer);
            this.registerBeans(deploymentVisitor.getBeanClasses(), beanDeployer);
            this.fireAfterBeanDiscoveryEvent();
            log.debug((Object)"Web Beans initialized. Validating beans.", new Object[0]);
            this.getServices().get(Validator.class).validateDeployment(this.manager, beanDeployer.getBeanDeployerEnvironment());
            this.fireAfterDeploymentValidationEvent();
            this.endDeploy(requestBeanStore);
        }
    }

    private void parseBeansXml(Iterable<URL> urls) {
        BeansXmlParser parser = new BeansXmlParser(this.getServices().get(ResourceLoader.class), urls);
        parser.parse();
        if (parser.getEnabledDeploymentTypes() != null) {
            this.manager.setEnabledDeploymentTypes(parser.getEnabledDeploymentTypes());
        }
        if (parser.getEnabledDecoratorClasses() != null) {
            this.manager.setEnabledDecoratorClasses(parser.getEnabledDecoratorClasses());
        }
        if (parser.getEnabledInterceptorClasses() != null) {
            this.manager.setEnabledInterceptorClasses(parser.getEnabledInterceptorClasses());
        }
        log.debug((Object)("Enabled deployment types: " + this.manager.getEnabledDeploymentTypes()), new Object[0]);
        log.debug((Object)("Enabled decorator types: " + this.manager.getEnabledDecoratorClasses()), new Object[0]);
        log.debug((Object)("Enabled interceptor types: " + this.manager.getEnabledInterceptorClasses()), new Object[0]);
    }

    private void fireBeforeBeanDiscoveryEvent(BeanDeployer beanDeployer) {
        BeforeBeanDiscoveryImpl event = new BeforeBeanDiscoveryImpl(this.getManager(), beanDeployer);
        try {
            this.getManager().fireEvent(event, new Annotation[0]);
        }
        catch (Exception e) {
            throw new DefinitionException(e);
        }
    }

    private void fireBeforeShutdownEvent() {
        BeforeShutdownImpl event = new BeforeShutdownImpl();
        try {
            this.getManager().fireEvent(event, new Annotation[0]);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    private void fireAfterBeanDiscoveryEvent() {
        AfterBeanDiscoveryImpl event = new AfterBeanDiscoveryImpl(this.getManager());
        try {
            this.manager.fireEvent(event, new Annotation[0]);
        }
        catch (Exception e) {
            event.addDefinitionError(e);
        }
        if (event.getDefinitionErrors().size() > 0) {
            throw new DefinitionException(event.getDefinitionErrors().get(0));
        }
    }

    private void fireAfterDeploymentValidationEvent() {
        AfterDeploymentValidationImpl event = new AfterDeploymentValidationImpl();
        try {
            this.manager.fireEvent(event, new Annotation[0]);
        }
        catch (Exception e) {
            event.addDeploymentProblem(e);
        }
        if (event.getDeploymentProblems().size() > 0) {
            throw new DeploymentException(event.getDeploymentProblems().get(0));
        }
    }

    public static String getVersion() {
        Package pkg = WebBeansBootstrap.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    protected void initializeContexts() {
        this.manager.addContext(DependentContext.instance());
        this.manager.addContext(RequestContext.instance());
        this.manager.addContext(ConversationContext.instance());
        this.manager.addContext(SessionContext.instance());
        this.manager.addContext(ApplicationContext.instance());
    }

    protected void createContexts() {
        this.getServices().add(ContextLifecycle.class, new ContextLifecycle());
        this.getServices().add(DependentContext.class, new DependentContext());
        this.getServices().add(RequestContext.class, new RequestContext());
        this.getServices().add(ConversationContext.class, new ConversationContext());
        this.getServices().add(SessionContext.class, new SessionContext());
        this.getServices().add(ApplicationContext.class, new ApplicationContext());
    }

    protected void beginApplication(BeanStore applicationBeanStore) {
        log.trace((Object)"Starting application", new Object[0]);
        ApplicationContext.instance().setBeanStore(applicationBeanStore);
        ApplicationContext.instance().setActive(true);
    }

    protected void beginDeploy(BeanStore requestBeanStore) {
        RequestContext.instance().setBeanStore(requestBeanStore);
        RequestContext.instance().setActive(true);
    }

    protected void endDeploy(BeanStore requestBeanStore) {
        RequestContext.instance().setBeanStore(null);
        RequestContext.instance().setActive(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            this.fireBeforeShutdownEvent();
        }
        finally {
            this.manager.shutdown();
        }
    }

    static {
        log.info((Object)("Web Beans " + WebBeansBootstrap.getVersion()), new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentVisitor {
        private final Collection<Class<?>> beanClasses;
        private final Collection<URL> beansXmlUrls;
        private final Collection<EjbDescriptor<?>> ejbDescriptors;
        private final Deployment deployment;

        public DeploymentVisitor(Deployment deployment) {
            this.deployment = deployment;
            this.beanClasses = new ArrayList();
            this.beansXmlUrls = new ArrayList<URL>();
            this.ejbDescriptors = new ArrayList();
        }

        public DeploymentVisitor visit() {
            for (BeanDeploymentArchive archvive : this.deployment.getBeanDeploymentArchives()) {
                this.visit(archvive);
            }
            return this;
        }

        private void visit(BeanDeploymentArchive beanDeploymentArchive) {
            for (Class<?> clazz : beanDeploymentArchive.getBeanClasses()) {
                this.beanClasses.add(clazz);
            }
            for (URL uRL : beanDeploymentArchive.getBeansXml()) {
                this.beansXmlUrls.add(uRL);
            }
            for (EjbDescriptor ejbDescriptor : beanDeploymentArchive.getEjbs()) {
                this.ejbDescriptors.add(ejbDescriptor);
            }
            for (BeanDeploymentArchive beanDeploymentArchive2 : beanDeploymentArchive.getBeanDeploymentArchives()) {
                this.visit(beanDeploymentArchive2);
            }
        }

        public Iterable<Class<?>> getBeanClasses() {
            return this.beanClasses;
        }

        public Iterable<URL> getBeansXmlUrls() {
            return this.beansXmlUrls;
        }

        public Iterable<EjbDescriptor<?>> getEjbDescriptors() {
            return this.ejbDescriptors;
        }
    }
}

