/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.webbeans.context.api.BeanInstance;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentInstancesStore {
    private static Log log = Logging.getLog(DependentInstancesStore.class);
    private List<BeanInstance<?>> dependentInstances = Collections.synchronizedList(new ArrayList());

    public <T> void addDependentInstance(BeanInstance<T> contextualInstance) {
        log.trace((Object)"Registered dependent instance #0", contextualInstance);
        this.dependentInstances.add(contextualInstance);
    }

    public void destroyDependentInstances() {
        log.trace((Object)"Destroying dependent instances", new Object[0]);
        for (BeanInstance<?> injectedInstance : this.dependentInstances) {
            DependentInstancesStore.destroy(injectedInstance);
        }
    }

    private static <T> void destroy(BeanInstance<T> beanInstance) {
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
    }

    public String toString() {
        return "Dependent Instances: " + this.dependentInstances;
    }
}

