/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.event.TransactionSynchronizedRunnable;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.transaction.spi.TransactionServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionalObserverImpl<T>
extends ObserverImpl<T> {
    private TransactionPhase transactionPhase;

    public static TransactionPhase getTransactionalPhase(WBMethod<?> observer) {
        WBParameter<?> parameter = observer.getAnnotatedParameters(Observes.class).iterator().next();
        return parameter.getAnnotationStore().getAnnotation(Observes.class).during();
    }

    protected TransactionalObserverImpl(WBMethod<?> observer, RIBean<?> observerBean, TransactionPhase transactionPhase, BeanManagerImpl manager) {
        super(observer, observerBean, manager);
        this.transactionPhase = transactionPhase;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public boolean notify(T event) {
        if (this.manager.getServices().get(TransactionServices.class) != null && this.manager.getServices().get(TransactionServices.class).isTransactionActive()) {
            this.deferEvent(event);
        } else {
            this.sendEvent(event);
        }
        return false;
    }

    private void deferEvent(T event) {
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, this);
        TransactionSynchronizedRunnable synchronization = null;
        if (this.transactionPhase.equals((Object)TransactionPhase.BEFORE_COMPLETION)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, true);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_COMPLETION)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, false);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_SUCCESS)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, TransactionServices.Status.SUCCESS);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_FAILURE)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, TransactionServices.Status.FAILURE);
        }
        this.manager.getServices().get(TransactionServices.class).registerSynchronization(synchronization);
    }
}

