/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.injection.Exceptions;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.ForwardingWBField;
import org.jboss.webbeans.introspector.WBField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInjectionPoint<T>
extends ForwardingWBField<T>
implements WBInjectionPoint<T, Field> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Bean<?> declaringBean;
    private final WBField<T> field;

    public static <T> FieldInjectionPoint<T> of(Bean<?> declaringBean, WBField<T> field) {
        return new FieldInjectionPoint<T>(declaringBean, field);
    }

    protected FieldInjectionPoint(Bean<?> declaringBean, WBField<T> field) {
        this.declaringBean = declaringBean;
        this.field = field;
    }

    @Override
    protected WBField<T> delegate() {
        return this.field;
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getBindings() {
        return this.delegate().getAnnotationStore().getBindings();
    }

    public void inject(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            this.delegate().set(declaringInstance, manager.getInjectableReference(this, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            this.delegate().set(declaringInstance, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public Annotated getAnnotated() {
        return this.delegate();
    }

    @Override
    public boolean isDelegate() {
        return false;
    }

    @Override
    public Type getType() {
        return this.getBaseType();
    }

    @Override
    public Member getMember() {
        return this.getJavaMember();
    }
}

