/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBType;
import org.jboss.webbeans.introspector.jlr.AbstractWBAnnotated;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWBType<T>
extends AbstractWBAnnotated<T, Class<T>>
implements WBType<T> {
    private final WBClass<?> superclass;
    private final String name;
    private final String _simpleName;
    private String toString;
    private final boolean _public;
    private final boolean _private;

    public AbstractWBType(AnnotationStore annotatedItemHelper, Class<T> rawType, Type type, ClassTransformer classTransformer) {
        super(annotatedItemHelper, rawType, type);
        this.name = rawType.getName();
        this._simpleName = rawType.getSimpleName();
        this.superclass = rawType.getSuperclass() != null ? classTransformer.loadClass(rawType.getSuperclass()) : null;
        this._public = Modifier.isFinal(rawType.getModifiers());
        this._private = Modifier.isPrivate(rawType.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic((Class)this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal((Class)this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return this._public;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WBClass<?> getSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isEquivalent(Class<?> clazz) {
        return ((Class)this.getDelegate()).equals(clazz);
    }

    @Override
    public boolean isPrivate() {
        return this._private;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated type " + this.getName();
        return this.toString;
    }

    @Override
    public String getSimpleName() {
        return this._simpleName;
    }
}

