/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata.cache;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.metadata.cache.StereotypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedStereotypes<T, E> {
    private final Map<Class<? extends Annotation>, Annotation> possibleDeploymentTypes = new HashMap<Class<? extends Annotation>, Annotation>();
    private final Set<Annotation> possibleScopeTypes = new HashSet<Annotation>();
    private boolean beanNameDefaulted;
    private final BeanManagerImpl manager;

    public MergedStereotypes(Set<Annotation> stereotypeAnnotations, BeanManagerImpl manager) {
        this.manager = manager;
        this.merge(stereotypeAnnotations);
    }

    protected void merge(Set<Annotation> stereotypeAnnotations) {
        for (Annotation stereotypeAnnotation : stereotypeAnnotations) {
            StereotypeModel<? extends Annotation> stereotype = this.manager.getServices().get(MetaAnnotationStore.class).getStereotype(stereotypeAnnotation.annotationType());
            if (stereotype == null) {
                throw new IllegalStateException("Stereotype " + stereotypeAnnotation + " not registered with container");
            }
            if (stereotype.getDefaultDeploymentType() != null) {
                this.possibleDeploymentTypes.put(stereotype.getDefaultDeploymentType().annotationType(), stereotype.getDefaultDeploymentType());
            }
            if (stereotype.getDefaultScopeType() != null) {
                this.possibleScopeTypes.add(stereotype.getDefaultScopeType());
            }
            if (!stereotype.isBeanNameDefaulted()) continue;
            this.beanNameDefaulted = true;
        }
    }

    public Map<Class<? extends Annotation>, Annotation> getPossibleDeploymentTypes() {
        return this.possibleDeploymentTypes;
    }

    public Set<Annotation> getPossibleScopeTypes() {
        return this.possibleScopeTypes;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    public boolean isDeclaredInXml() {
        return false;
    }

    public String toString() {
        return "Merged stereotype model with possible deployment types " + this.possibleDeploymentTypes + " and possible scopes " + this.possibleScopeTypes;
    }
}

