/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.decorator.Decorates;
import javax.enterprise.inject.BindingType;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.metadata.cache.BindingTypeModel;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.collections.ListComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Beans {
    public static boolean isPassivatingBean(Bean<?> bean, BeanManagerImpl manager) {
        if (bean instanceof EnterpriseBean) {
            return ((EnterpriseBean)bean).getEjbDescriptor().isStateful();
        }
        return manager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScopeType()).isPassivating();
    }

    public static boolean isBeanProxyable(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Proxies.isTypesProxyable(bean.getTypes());
    }

    public static Set<FieldInjectionPoint<?>> getFieldInjectionPoints(WBClass<?> annotatedItem, Bean<?> declaringBean) {
        HashSet injectableFields = new HashSet();
        for (WBField<?> annotatedField : annotatedItem.getMetaAnnotatedFields(BindingType.class)) {
            Beans.addFieldInjectionPoint(annotatedField, injectableFields, declaringBean);
        }
        for (WBField<?> annotatedField : annotatedItem.getAnnotatedFields(Decorates.class)) {
            Beans.addFieldInjectionPoint(annotatedField, injectableFields, declaringBean);
        }
        return injectableFields;
    }

    private static void addFieldInjectionPoint(WBField<?> annotatedField, Set<FieldInjectionPoint<?>> injectableFields, Bean<?> declaringBean) {
        if (!annotatedField.isAnnotationPresent(Produces.class)) {
            if (annotatedField.isStatic()) {
                throw new DefinitionException("Don't place binding annotations on static fields " + annotatedField);
            }
            if (annotatedField.isFinal()) {
                throw new DefinitionException("Don't place binding annotations on final fields " + annotatedField);
            }
            FieldInjectionPoint<?> fieldInjectionPoint = FieldInjectionPoint.of(declaringBean, annotatedField);
            injectableFields.add(fieldInjectionPoint);
        }
    }

    public static boolean containsAllBindings(Set<Annotation> bindings1, Set<Annotation> bindings2, BeanManagerImpl manager) {
        for (Annotation binding : bindings1) {
            BindingTypeModel<? extends Annotation> bindingType = manager.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(binding.annotationType());
            boolean matchFound = false;
            for (Annotation otherBinding : bindings2) {
                if (!bindingType.isEqual(binding, otherBinding)) continue;
                matchFound = true;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public static <T extends Bean<?>> Set<T> retainHighestPrecedenceBeans(Set<T> beans, List<Class<? extends Annotation>> enabledDeployentTypes) {
        if (beans.size() > 0) {
            TreeSet<Class<? extends Annotation>> possibleDeploymentTypes = new TreeSet<Class<? extends Annotation>>(new ListComparator<Class<? extends Annotation>>(enabledDeployentTypes));
            for (Bean bean : beans) {
                possibleDeploymentTypes.add(bean.getDeploymentType());
            }
            possibleDeploymentTypes.retainAll(enabledDeployentTypes);
            HashSet<Bean> trimmed = new HashSet<Bean>();
            if (possibleDeploymentTypes.size() > 0) {
                Class highestPrecedencePossibleDeploymentType = (Class)possibleDeploymentTypes.last();
                for (Bean bean : beans) {
                    if (!bean.getDeploymentType().equals(highestPrecedencePossibleDeploymentType)) continue;
                    trimmed.add(bean);
                }
            }
            return trimmed;
        }
        return beans;
    }
}

