/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.ELResolver;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ScopeType;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observer;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.BindingType;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.deployment.Production;
import javax.enterprise.inject.deployment.Standard;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.webbeans.BeanIdStore;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.Validator;
import org.jboss.webbeans.WebBean;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.proxy.ClientProxyProvider;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.CreationalContextImpl;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.el.Namespace;
import org.jboss.webbeans.el.WebBeansELResolverImpl;
import org.jboss.webbeans.event.EventObserver;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.literal.AnyLiteral;
import org.jboss.webbeans.literal.CurrentLiteral;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.manager.api.WebBeansManager;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.resolution.NameBasedResolver;
import org.jboss.webbeans.resolution.ResolvableFactory;
import org.jboss.webbeans.resolution.ResolvableWBClass;
import org.jboss.webbeans.resolution.TypeSafeBeanResolver;
import org.jboss.webbeans.resolution.TypeSafeDecoratorResolver;
import org.jboss.webbeans.resolution.TypeSafeObserverResolver;
import org.jboss.webbeans.resolution.TypeSafeResolver;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Observers;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManagerImpl
implements WebBeansManager,
Serializable {
    private static final Log log = Logging.getLog(BeanManagerImpl.class);
    private static final long serialVersionUID = 3021562879133838561L;
    public static final String JNDI_KEY = "java:app/Manager";
    private final transient ExecutorService taskExecutor = Executors.newSingleThreadExecutor();
    private final transient ServiceRegistry services;
    private final transient ListMultimap<Class<? extends Annotation>, Context> contexts;
    private final transient ClientProxyProvider clientProxyProvider;
    private final transient AtomicInteger ids;
    private final transient Map<String, RIBean<?>> riBeans;
    private final transient Map<Class<?>, EnterpriseBean<?>> newEnterpriseBeans;
    private final transient Map<Contextual<?>, Contextual<?>> specializedBeans;
    private transient List<Class<? extends Annotation>> enabledDeploymentTypes;
    private transient List<Class<?>> enabledDecoratorClasses;
    private transient List<Class<?>> enabledInterceptorClasses;
    private final transient Set<CurrentActivity> currentActivities;
    private final transient TypeSafeResolver<Bean<?>> beanResolver;
    private final transient TypeSafeResolver<DecoratorBean<?>> decoratorResolver;
    private final transient TypeSafeResolver<EventObserver<?>> observerResolver;
    private final transient NameBasedResolver nameBasedResolver;
    private final transient ELResolver webbeansELResolver;
    private transient Namespace rootNamespace;
    private final transient List<Bean<?>> beans;
    private final transient List<DecoratorBean<?>> decorators;
    private final transient List<String> namespaces;
    private final transient List<EventObserver<?>> observers;
    private final transient HashSet<BeanManagerImpl> accessibleManagers;
    private final transient Set<BeanManagerImpl> childActivities;
    private final Integer id;
    private final transient ThreadLocal<Stack<InjectionPoint>> currentInjectionPoint;

    public static BeanManagerImpl newRootManager(ServiceRegistry serviceRegistry) {
        ArrayList<Class<? extends Annotation>> defaultEnabledDeploymentTypes = new ArrayList<Class<? extends Annotation>>();
        defaultEnabledDeploymentTypes.add(0, Standard.class);
        defaultEnabledDeploymentTypes.add(1, Production.class);
        ArrayList defaultEnabledDecoratorClasses = new ArrayList();
        ListMultimap<Class<? extends Annotation>, Context> contexts = Multimaps.newListMultimap(new ConcurrentHashMap(), new Supplier<List<Context>>(){

            @Override
            public List<Context> get() {
                return new CopyOnWriteArrayList<Context>();
            }
        });
        return new BeanManagerImpl(serviceRegistry, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), new ConcurrentHashMap(), new ConcurrentHashMap(), new ClientProxyProvider(), contexts, new CopyOnWriteArraySet<CurrentActivity>(), new HashMap(), defaultEnabledDeploymentTypes, defaultEnabledDecoratorClasses, new AtomicInteger());
    }

    public static BeanManagerImpl newChildManager(BeanManagerImpl parentManager) {
        CopyOnWriteArrayList beans = new CopyOnWriteArrayList();
        beans.addAll(parentManager.getBeans());
        CopyOnWriteArrayList registeredObservers = new CopyOnWriteArrayList();
        registeredObservers.addAll(parentManager.getObservers());
        CopyOnWriteArrayList<String> namespaces = new CopyOnWriteArrayList<String>();
        namespaces.addAll(parentManager.getNamespaces());
        return new BeanManagerImpl(parentManager.getServices(), beans, parentManager.getDecorators(), registeredObservers, namespaces, parentManager.getNewEnterpriseBeanMap(), parentManager.getRiBeans(), parentManager.getClientProxyProvider(), parentManager.getContexts(), parentManager.getCurrentActivities(), parentManager.getSpecializedBeans(), parentManager.getEnabledDeploymentTypes(), parentManager.getEnabledDecoratorClasses(), parentManager.getIds());
    }

    private BeanManagerImpl(ServiceRegistry serviceRegistry, List<Bean<?>> beans, List<DecoratorBean<?>> decorators, List<EventObserver<?>> observers, List<String> namespaces, Map<Class<?>, EnterpriseBean<?>> newEnterpriseBeans, Map<String, RIBean<?>> riBeans, ClientProxyProvider clientProxyProvider, ListMultimap<Class<? extends Annotation>, Context> contexts, Set<CurrentActivity> currentActivities, Map<Contextual<?>, Contextual<?>> specializedBeans, List<Class<? extends Annotation>> enabledDeploymentTypes, List<Class<?>> enabledDecoratorClasses, AtomicInteger ids) {
        this.services = serviceRegistry;
        this.beans = beans;
        this.decorators = decorators;
        this.newEnterpriseBeans = newEnterpriseBeans;
        this.riBeans = riBeans;
        this.clientProxyProvider = clientProxyProvider;
        this.contexts = contexts;
        this.currentActivities = currentActivities;
        this.specializedBeans = specializedBeans;
        this.observers = observers;
        this.setEnabledDeploymentTypes(enabledDeploymentTypes);
        this.setEnabledDecoratorClasses(enabledDecoratorClasses);
        this.namespaces = namespaces;
        this.ids = ids;
        this.id = ids.incrementAndGet();
        this.accessibleManagers = new HashSet();
        this.beanResolver = new TypeSafeBeanResolver(this, this.createDynamicAccessibleIterable(Transform.BEAN));
        this.decoratorResolver = new TypeSafeDecoratorResolver(this, this.createDynamicAccessibleIterable(Transform.DECORATOR_BEAN));
        this.observerResolver = new TypeSafeObserverResolver(this, this.createDynamicAccessibleIterable(Transform.EVENT_OBSERVER));
        this.nameBasedResolver = new NameBasedResolver(this, this.createDynamicAccessibleIterable(Transform.BEAN));
        this.webbeansELResolver = new WebBeansELResolverImpl(this);
        this.childActivities = new CopyOnWriteArraySet<BeanManagerImpl>();
        this.currentInjectionPoint = new ThreadLocal<Stack<InjectionPoint>>(){

            @Override
            protected Stack<InjectionPoint> initialValue() {
                return new Stack<InjectionPoint>();
            }
        };
    }

    private <T> Set<Iterable<T>> buildAccessibleClosure(Collection<BeanManagerImpl> hierarchy, Transform<T> transform) {
        HashSet<Iterable<T>> result = new HashSet<Iterable<T>>();
        hierarchy.add(this);
        result.add(transform.transform(this));
        for (BeanManagerImpl beanManager : this.accessibleManagers) {
            if (hierarchy.contains(beanManager)) continue;
            result.addAll(beanManager.buildAccessibleClosure(new ArrayList<BeanManagerImpl>(hierarchy), transform));
        }
        return result;
    }

    private <T> Iterable<T> createDynamicAccessibleIterable(final Transform<T> transform) {
        return new Iterable<T>(){
            private Function<Iterable<T>, Iterator<T>> function = new Function<Iterable<T>, Iterator<T>>(){

                @Override
                public Iterator<T> apply(Iterable<T> iterable) {
                    return iterable.iterator();
                }
            };

            @Override
            public Iterator<T> iterator() {
                Set iterable = BeanManagerImpl.this.buildAccessibleClosure(new ArrayList(), transform);
                return Iterators.concat(Iterators.transform(iterable.iterator(), this.function));
            }
        };
    }

    private <T> Iterable<T> createStaticAccessibleIterable(Transform<T> transform) {
        Set<Iterable<T>> iterable = this.buildAccessibleClosure(new ArrayList<BeanManagerImpl>(), transform);
        return Iterables.concat(iterable);
    }

    public void addAccessibleBeanManager(BeanManagerImpl accessibleBeanManager) {
        this.accessibleManagers.add(accessibleBeanManager);
    }

    protected Set<BeanManagerImpl> getAccessibleManagers() {
        return this.accessibleManagers;
    }

    protected void checkEnabledDeploymentTypes() {
        if (!this.enabledDeploymentTypes.get(0).equals(Standard.class)) {
            throw new InjectionException("@Standard must be the lowest precedence deployment type");
        }
    }

    protected void addWebBeansDeploymentTypes() {
        if (!this.enabledDeploymentTypes.contains(WebBean.class)) {
            this.enabledDeploymentTypes.add(1, WebBean.class);
        }
    }

    @Override
    public void addBean(Bean<?> bean) {
        if (this.beans.contains(bean)) {
            return;
        }
        if (bean instanceof NewEnterpriseBean) {
            NewEnterpriseBean newEnterpriseBean = (NewEnterpriseBean)bean;
            this.newEnterpriseBeans.put(newEnterpriseBean.getType(), newEnterpriseBean);
        } else if (bean instanceof DecoratorBean) {
            this.decorators.add((DecoratorBean)bean);
        }
        if (bean instanceof RIBean) {
            RIBean riBean = (RIBean)bean;
            this.riBeans.put(riBean.getId(), riBean);
        }
        this.getServices().get(BeanIdStore.class).put(bean, this);
        this.registerBeanNamespace(bean);
        for (BeanManagerImpl childActivity : this.childActivities) {
            childActivity.addBean(bean);
        }
        this.beans.add(bean);
        this.beanResolver.clear();
    }

    @Override
    public <T> Set<Observer<T>> resolveObservers(T event, Annotation ... bindings) {
        Class<?> clazz = event.getClass();
        for (Annotation annotation : bindings) {
            if (this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        HashSet<Annotation> bindingAnnotations = new HashSet<Annotation>(Arrays.asList(bindings));
        if (bindingAnnotations.size() < bindings.length) {
            throw new IllegalArgumentException("Duplicate binding types: " + bindings);
        }
        if (bindingAnnotations.size() == 0) {
            bindingAnnotations.add(new CurrentLiteral());
        }
        bindingAnnotations.add(new AnyLiteral());
        this.checkEventType(clazz);
        HashSet<Observer<T>> observers = new HashSet<Observer<T>>();
        Set<EventObserver<?>> eventObservers = this.observerResolver.resolve(ResolvableFactory.of(new Reflections.HierarchyDiscovery(clazz).getFlattenedTypes(), bindingAnnotations));
        for (EventObserver<?> observer : eventObservers) {
            observers.add(observer.getObserver());
        }
        return observers;
    }

    @Override
    public <T> Set<ObserverMethod<T, ?>> resolveObserverMethods(T event, Annotation ... bindings) {
        throw new UnsupportedOperationException();
    }

    private void checkEventType(Type eventType) {
        Type[] types;
        if (eventType instanceof Class) {
            types = Reflections.getActualTypeArguments((Class)eventType);
        } else if (eventType instanceof ParameterizedType) {
            types = ((ParameterizedType)eventType).getActualTypeArguments();
        } else {
            throw new IllegalArgumentException("Event type " + eventType + " isn't a concrete type");
        }
        for (Type type : types) {
            if (type instanceof WildcardType) {
                throw new IllegalArgumentException("Cannot provide an event type parameterized with a wildcard " + eventType);
            }
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot provide an event type parameterized with a type parameter " + eventType);
        }
    }

    @Override
    public List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        return Collections.unmodifiableList(this.enabledDeploymentTypes);
    }

    public List<Class<?>> getEnabledDecoratorClasses() {
        return Collections.unmodifiableList(this.enabledDecoratorClasses);
    }

    public List<Class<?>> getEnabledInterceptorClasses() {
        return Collections.unmodifiableList(this.enabledInterceptorClasses);
    }

    public void setEnabledDeploymentTypes(List<Class<? extends Annotation>> enabledDeploymentTypes) {
        this.enabledDeploymentTypes = new ArrayList<Class<? extends Annotation>>(enabledDeploymentTypes);
        this.checkEnabledDeploymentTypes();
        this.addWebBeansDeploymentTypes();
    }

    public void setEnabledDecoratorClasses(List<Class<?>> enabledDecoratorClasses) {
        this.enabledDecoratorClasses = enabledDecoratorClasses;
    }

    public void setEnabledInterceptorClasses(List<Class<?>> enabledInterceptorClasses) {
        this.enabledInterceptorClasses = enabledInterceptorClasses;
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... bindings) {
        return this.getBeans(ResolvableWBClass.of(beanType, bindings, this), bindings);
    }

    public Set<Bean<?>> getBeans(WBAnnotated<?, ?> element, Annotation ... bindings) {
        for (Annotation annotation : element.getAnnotations()) {
            if (this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        for (Type type : element.getActualTypeArguments()) {
            if (type instanceof WildcardType) {
                throw new IllegalArgumentException("Cannot resolve a type parameterized with a wildcard " + element);
            }
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot resolve a type parameterized with a type parameter " + element);
        }
        if (bindings != null && bindings.length > element.getMetaAnnotations(BindingType.class).size()) {
            throw new IllegalArgumentException("Duplicate bindings (" + Arrays.asList(bindings) + ") type passed " + element.toString());
        }
        return this.beanResolver.resolve(ResolvableFactory.of(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Bean<?>> getInjectableBeans(InjectionPoint injectionPoint) {
        boolean registerInjectionPoint = !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().push(injectionPoint);
            }
            Set<Bean<?>> beans = this.getBeans(ResolvableWBClass.of(injectionPoint.getType(), injectionPoint.getBindings().toArray(new Annotation[0]), this), new Annotation[0]);
            HashSet injectableBeans = new HashSet();
            for (Bean<?> bean : beans) {
                if (bean instanceof Decorator || bean instanceof Interceptor) continue;
                injectableBeans.add(bean);
            }
            HashSet hashSet = injectableBeans;
            return hashSet;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().pop();
            }
        }
    }

    protected void registerBeanNamespace(Bean<?> bean) {
        if (bean.getName() != null && bean.getName().indexOf(46) > 0) {
            this.namespaces.add(bean.getName().substring(0, bean.getName().lastIndexOf(46)));
        }
    }

    public Map<Class<?>, EnterpriseBean<?>> getNewEnterpriseBeanMap() {
        return this.newEnterpriseBeans;
    }

    public List<Bean<?>> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    public List<DecoratorBean<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    public Map<String, RIBean<?>> getRiBeans() {
        return Collections.unmodifiableMap(this.riBeans);
    }

    @Override
    public void addContext(Context context) {
        this.contexts.put(context.getScopeType(), context);
    }

    @Override
    @Deprecated
    public void addObserver(Observer<?> observer, Annotation ... bindings) {
        this.addObserver(observer, Observers.getTypeOfObserver(observer), bindings);
    }

    @Deprecated
    public <T> void addObserver(ObserverImpl<T> observer) {
        this.addObserver(observer, observer.getEventType(), observer.getBindingsAsArray());
    }

    @Deprecated
    public void addObserver(Observer<?> observer, Type eventType, Annotation ... bindings) {
        this.checkEventType(eventType);
        EventObserver<?> eventObserver = EventObserver.of(observer, eventType, this, bindings);
        this.observers.add(eventObserver);
        log.trace((Object)("Added observer " + observer + " observing event type " + eventType), new Object[0]);
        for (BeanManagerImpl childActivity : this.childActivities) {
            childActivity.addObserver(observer, eventType, bindings);
        }
    }

    @Override
    @Deprecated
    public void removeObserver(Observer<?> observer) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(Object event, Annotation ... bindings) {
        if (Reflections.isParameterizedType(event.getClass())) {
            throw new IllegalArgumentException("Event type " + event.getClass().getName() + " is not allowed because it is a generic");
        }
        for (Annotation binding : bindings) {
            if (Reflections.isBindings(binding)) continue;
            throw new IllegalArgumentException("Event type " + event.getClass().getName() + " cannot be fired with non-binding type " + binding.getClass().getName() + " specified");
        }
        Set<Observer<Object>> observers = this.resolveObservers(event, bindings);
        try {
            DependentContext.instance().setActive(true);
            for (Observer<Object> observer : observers) {
                observer.notify(event);
            }
        }
        finally {
            DependentContext.instance().setActive(false);
        }
    }

    @Override
    public Context getContext(Class<? extends Annotation> scopeType) {
        ArrayList<Context> activeContexts = new ArrayList<Context>();
        for (Context context : this.contexts.get(scopeType)) {
            if (!context.isActive()) continue;
            activeContexts.add(context);
        }
        if (activeContexts.isEmpty()) {
            throw new ContextNotActiveException("No active contexts for scope type " + scopeType.getName());
        }
        if (activeContexts.size() > 1) {
            throw new IllegalStateException("More than one context active for scope type " + scopeType.getName());
        }
        return (Context)activeContexts.iterator().next();
    }

    public Object getReference(Bean<?> bean, CreationalContext<?> creationalContext) {
        bean = this.getMostSpecializedBean(bean);
        if (creationalContext instanceof CreationalContextImpl) {
            creationalContext = ((CreationalContextImpl)creationalContext).getCreationalContext(bean);
        }
        if (this.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScopeType()).isNormal()) {
            if (creationalContext != null || creationalContext == null && this.getContext(bean.getScopeType()).get(bean) != null) {
                return this.clientProxyProvider.getClientProxy(this, bean);
            }
            return null;
        }
        return this.getContext(bean.getScopeType()).get(bean, creationalContext);
    }

    @Override
    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        if (!bean.getTypes().contains(beanType)) {
            throw new IllegalArgumentException("The given beanType is not a type " + beanType + " of the bean " + bean);
        }
        return this.getReference(bean, creationalContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        boolean registerInjectionPoint = !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().push(injectionPoint);
            }
            WBAnnotated element = ResolvableWBClass.of(injectionPoint.getType(), injectionPoint.getBindings().toArray(new Annotation[0]), this);
            Bean resolvedBean = this.getBean(element, element.getBindingsAsArray());
            if (this.getServices().get(MetaAnnotationStore.class).getScopeModel(resolvedBean.getScopeType()).isNormal() && !Proxies.isTypeProxyable(injectionPoint.getType())) {
                throw new UnproxyableResolutionException("Attempting to inject an unproxyable normal scoped bean " + resolvedBean + " into " + injectionPoint);
            }
            if (creationalContext instanceof CreationalContextImpl) {
                CreationalContextImpl creationalContextImpl = (CreationalContextImpl)creationalContext;
                if (creationalContextImpl.containsIncompleteInstance(resolvedBean)) {
                    Object t = creationalContextImpl.getIncompleteInstance(resolvedBean);
                    return t;
                }
                Object object = this.getReference(resolvedBean, creationalContextImpl);
                return object;
            }
            Object object = this.getReference(resolvedBean, creationalContext);
            return object;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().pop();
            }
        }
    }

    @Deprecated
    public <T> T getInstanceByType(Class<T> type, Annotation ... bindings) {
        WBAnnotated element = ResolvableWBClass.of(type, bindings, this);
        Bean bean = this.getBean(element, bindings);
        return (T)this.getReference(bean, type, this.createCreationalContext((Contextual)bean));
    }

    public <T> Bean<T> getBean(WBAnnotated<T, ?> element, Annotation ... bindings) {
        Set<Bean<?>> beans = this.getBeans(element, bindings);
        if (beans.size() == 0) {
            throw new UnsatisfiedResolutionException(element + "Unable to resolve any Web Beans");
        }
        if (beans.size() > 1) {
            throw new AmbiguousResolutionException(element + "Resolved multiple Web Beans");
        }
        Bean<?> bean = beans.iterator().next();
        boolean normalScoped = this.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScopeType()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw new UnproxyableResolutionException("Normal scoped bean " + bean + " is not proxyable");
        }
        return bean;
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        return this.nameBasedResolver.resolve(name);
    }

    @Override
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... bindings) {
        return new ArrayList(this.decoratorResolver.resolve(ResolvableFactory.of(types, bindings)));
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Set<Annotation> bindings) {
        return new ArrayList(this.decoratorResolver.resolve(ResolvableFactory.of(types, bindings)));
    }

    @Override
    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        throw new UnsupportedOperationException();
    }

    public TypeSafeResolver getBeanResolver() {
        return this.beanResolver;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Manager\n");
        buffer.append("Enabled deployment types: " + this.getEnabledDeploymentTypes() + "\n");
        buffer.append("Registered contexts: " + this.contexts.keySet() + "\n");
        buffer.append("Registered beans: " + this.getBeans().size() + "\n");
        buffer.append("Specialized beans: " + this.specializedBeans.size() + "\n");
        return buffer.toString();
    }

    @Override
    public BeanManagerImpl createActivity() {
        BeanManagerImpl childActivity = BeanManagerImpl.newChildManager(this);
        this.childActivities.add(childActivity);
        CurrentManager.add(childActivity);
        return childActivity;
    }

    @Override
    public BeanManagerImpl setCurrent(Class<? extends Annotation> scopeType) {
        if (!this.getServices().get(MetaAnnotationStore.class).getScopeModel(scopeType).isNormal()) {
            throw new IllegalArgumentException("Scope must be a normal scope type " + scopeType);
        }
        this.currentActivities.add(new CurrentActivity(this.getContext(scopeType), this));
        return this;
    }

    public BeanManagerImpl getCurrent() {
        ArrayList<CurrentActivity> activeCurrentActivities = new ArrayList<CurrentActivity>();
        for (CurrentActivity currentActivity : this.currentActivities) {
            if (!currentActivity.getContext().isActive()) continue;
            activeCurrentActivities.add(currentActivity);
        }
        if (activeCurrentActivities.size() == 0) {
            return CurrentManager.rootManager();
        }
        if (activeCurrentActivities.size() == 1) {
            return ((CurrentActivity)activeCurrentActivities.get(0)).getManager();
        }
        throw new IllegalStateException("More than one current activity for an active context " + this.currentActivities);
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public InjectionPoint getInjectionPoint() {
        if (!this.currentInjectionPoint.get().empty()) {
            return this.currentInjectionPoint.get().peek();
        }
        return null;
    }

    public Map<Contextual<?>, Contextual<?>> getSpecializedBeans() {
        return this.specializedBeans;
    }

    protected Object readResolve() {
        return CurrentManager.get(this.id);
    }

    public ExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    public void shutdown() {
        log.trace((Object)"Ending application", new Object[0]);
        this.shutdownExecutors();
        ApplicationContext.instance().destroy();
        ApplicationContext.instance().setActive(false);
        ApplicationContext.instance().setBeanStore(null);
        CurrentManager.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void shutdownExecutors() {
        this.taskExecutor.shutdown();
        try {
            if (this.taskExecutor.awaitTermination(60L, TimeUnit.SECONDS)) return;
            this.taskExecutor.shutdownNow();
            if (this.taskExecutor.awaitTermination(60L, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException ie) {
            this.taskExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected ClientProxyProvider getClientProxyProvider() {
        return this.clientProxyProvider;
    }

    protected ListMultimap<Class<? extends Annotation>, Context> getContexts() {
        return this.contexts;
    }

    protected List<String> getNamespaces() {
        return this.namespaces;
    }

    protected AtomicInteger getIds() {
        return this.ids;
    }

    private Set<CurrentActivity> getCurrentActivities() {
        return this.currentActivities;
    }

    public Integer getId() {
        return this.id;
    }

    public List<EventObserver<?>> getObservers() {
        return this.observers;
    }

    public Namespace getRootNamespace() {
        if (this.rootNamespace == null) {
            this.rootNamespace = new Namespace(this.createDynamicAccessibleIterable(Transform.NAMESPACE));
        }
        return this.rootNamespace;
    }

    public <T> InjectionTarget<T> createInjectionTarget(Class<T> type) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public <X> Bean<? extends X> getMostSpecializedBean(Bean<X> bean) {
        Contextual<Object> key = bean;
        while (this.specializedBeans.containsKey(key)) {
            if (key == null) {
                System.out.println("null key " + bean);
            }
            key = this.specializedBeans.get(key);
        }
        return key;
    }

    @Override
    public void validate(InjectionPoint ij) {
        this.getServices().get(Validator.class).validateInjectionPoint(ij, this);
    }

    @Override
    public Set<Annotation> getInterceptorBindingTypeDefinition(Class<? extends Annotation> bindingType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public ScopeType getScopeDefinition(Class<? extends Annotation> scopeType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isBindingType(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isInterceptorBindingType(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isScopeType(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public <X> Bean<? extends X> getHighestPrecedenceBean(Set<Bean<? extends X>> beans) {
        return this.resolve(beans);
    }

    @Override
    public ELResolver getELResolver() {
        return this.webbeansELResolver;
    }

    public <T> CreationalContextImpl<T> createCreationalContext(Contextual<T> contextual) {
        return new CreationalContextImpl<T>(contextual);
    }

    @Override
    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        if (beans.size() == 1) {
            return beans.iterator().next();
        }
        if (beans.isEmpty()) {
            return null;
        }
        final List<Class<? extends Annotation>> enabledDeploymentTypes = this.getEnabledDeploymentTypes();
        TreeSet<Bean<X>> sortedBeans = new TreeSet<Bean<X>>(new Comparator<Bean<? extends X>>(){

            @Override
            public int compare(Bean<? extends X> o1, Bean<? extends X> o2) {
                int diff = enabledDeploymentTypes.indexOf(o1) - enabledDeploymentTypes.indexOf(o2);
                if (diff == 0) {
                    throw new AmbiguousResolutionException();
                }
                return diff;
            }
        });
        sortedBeans.addAll(beans);
        return (Bean)sortedBeans.last();
    }

    public void addRIBean(RIBean<?> bean) {
        this.addBean(bean);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Transform<T> {
        public static final Transform<Bean<?>> BEAN = new Transform<Bean<?>>(){

            @Override
            public Iterable<Bean<?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getBeans();
            }
        };
        public static final Transform<DecoratorBean<?>> DECORATOR_BEAN = new Transform<DecoratorBean<?>>(){

            @Override
            public Iterable<DecoratorBean<?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getDecorators();
            }
        };
        public static final Transform<EventObserver<?>> EVENT_OBSERVER = new Transform<EventObserver<?>>(){

            @Override
            public Iterable<EventObserver<?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getObservers();
            }
        };
        public static final Transform<String> NAMESPACE = new Transform<String>(){

            @Override
            public Iterable<String> transform(BeanManagerImpl beanManager) {
                return beanManager.getNamespaces();
            }
        };

        public Iterable<T> transform(BeanManagerImpl var1);
    }

    private static class CurrentActivity {
        private final Context context;
        private final BeanManagerImpl manager;

        public CurrentActivity(Context context, BeanManagerImpl manager) {
            this.context = context;
            this.manager = manager;
        }

        public Context getContext() {
            return this.context;
        }

        public BeanManagerImpl getManager() {
            return this.manager;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CurrentActivity) {
                return this.getContext().equals(((CurrentActivity)obj).getContext());
            }
            return false;
        }

        public int hashCode() {
            return this.getContext().hashCode();
        }

        public String toString() {
            return this.getContext() + " -> " + this.getManager();
        }
    }
}

