/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.context.AbstractContext;
import org.jboss.webbeans.context.BeanInstanceImpl;
import org.jboss.webbeans.context.CreationalContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentContext
extends AbstractContext
implements Service {
    private final ThreadLocal<AtomicInteger> reentrantActiveCount;

    public static DependentContext instance() {
        return CurrentManager.rootManager().getServices().get(DependentContext.class);
    }

    public DependentContext() {
        super(Dependent.class);
        super.setActive(false);
        this.reentrantActiveCount = new ThreadLocal<AtomicInteger>(){

            @Override
            protected AtomicInteger initialValue() {
                return new AtomicInteger(0);
            }
        };
    }

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (creationalContext != null) {
            T instance = contextual.create(creationalContext);
            if (creationalContext instanceof CreationalContextImpl) {
                CreationalContextImpl creationalContextImpl = (CreationalContextImpl)creationalContext;
                BeanInstanceImpl<T> beanInstance = new BeanInstanceImpl<T>(contextual, instance, creationalContext);
                creationalContextImpl.getParentDependentInstancesStore().addDependentInstance(beanInstance);
            }
            return instance;
        }
        return null;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public String toString() {
        String active = this.isActive() ? "Active " : "Inactive ";
        return active + "dependent context";
    }

    @Override
    public void setActive(boolean active) {
        if (active) {
            if (this.reentrantActiveCount.get().incrementAndGet() == 1) {
                super.setActive(true);
            }
        } else if (this.reentrantActiveCount.get().decrementAndGet() == 0) {
            super.setActive(false);
        }
    }

    @Deprecated
    public <T> void destroyAndRemove(Contextual<T> contextual, T instance) {
        if (contextual instanceof Contextual) {
            CreationalContextImpl<T> creationalContext = new CreationalContextImpl<T>(contextual);
            contextual.destroy(instance, creationalContext.getCreationalContext(contextual));
        }
    }
}

