/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Notify;
import javax.enterprise.event.Observer;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Initializer;
import javax.enterprise.inject.Produces;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverImpl<T>
implements Observer<T> {
    protected final RIBean<?> observerBean;
    protected final MethodInjectionPoint<?> observerMethod;
    private final boolean conditional;
    protected BeanManagerImpl manager;
    private final Type eventType;
    private final Annotation[] bindings;

    protected ObserverImpl(WBMethod<?> observer, RIBean<?> observerBean, BeanManagerImpl manager) {
        this.manager = manager;
        this.observerBean = observerBean;
        this.observerMethod = MethodInjectionPoint.of(observerBean, observer);
        this.eventType = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getBaseType();
        this.bindings = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getBindingsAsArray();
        Observes observesAnnotation = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getAnnotation(Observes.class);
        this.conditional = observesAnnotation.notifyObserver().equals((Object)Notify.IF_EXISTS);
    }

    public void initialize() {
        this.checkObserverMethod();
    }

    private void checkObserverMethod() {
        List<WBParameter<?>> disposeParams;
        WBParameter<?> eventParam;
        List<WBParameter<?>> eventObjects = this.observerMethod.getAnnotatedParameters(Observes.class);
        if (eventObjects.size() > 1) {
            throw new DefinitionException(this + " is invalid because it contains more than event parameter annotated @Observes");
        }
        if (eventObjects.size() > 0 && (eventParam = eventObjects.iterator().next()).isParameterizedType()) {
            for (Type type : eventParam.getActualTypeArguments()) {
                if (type instanceof TypeVariable) {
                    throw new DefinitionException("Cannot use a type variable " + type + " in an parameterized type " + this.toString());
                }
                if (!(type instanceof WildcardType)) continue;
                throw new DefinitionException("Cannot use a wildcard variable " + type + " in an parameterized type " + this.toString());
            }
        }
        if ((disposeParams = this.observerMethod.getAnnotatedParameters(Disposes.class)).size() > 0) {
            throw new DefinitionException(this + " cannot have any parameters annotated with @Disposes");
        }
        if (this.observerMethod.isAnnotationPresent(Produces.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Produces");
        }
        if (this.observerMethod.isAnnotationPresent(Initializer.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Initializer");
        }
    }

    @Override
    public boolean notify(T event) {
        this.sendEvent(event);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(T event) {
        Object instance = null;
        CreationalContext creationalContext = null;
        try {
            if (!this.conditional) {
                creationalContext = this.manager.createCreationalContext((Contextual)this.observerBean);
            }
            if ((instance = this.manager.getReference(this.observerBean, creationalContext)) == null) {
                return;
            }
            this.observerMethod.invokeOnInstanceWithSpecialValue(instance, Observes.class, event, this.manager, creationalContext, ObserverException.class);
        }
        finally {
            if (creationalContext != null && Dependent.class.equals(this.observerBean.getScopeType())) {
                creationalContext.release();
            }
        }
    }

    protected void sendEventAsynchronously(T event) {
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, this);
        this.manager.getTaskExecutor().execute(deferredEvent);
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Observer Implementation: \n");
        builder.append("  Observer (Declaring) class: " + Names.typesToString(this.observerBean.getTypes()));
        builder.append("  Observer method: " + this.observerMethod);
        return builder.toString();
    }

    public Type getEventType() {
        return this.eventType;
    }

    public Annotation[] getBindingsAsArray() {
        return this.bindings;
    }
}

