/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resources;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.introspector.WBAnnotation;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.jlr.WBAnnotationImpl;
import org.jboss.webbeans.introspector.jlr.WBClassImpl;
import org.jboss.webbeans.metadata.TypeStore;
import org.jboss.webbeans.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTransformer
implements Service {
    private final ConcurrentCache<Class<?>, WBClass<?>> classes;
    private final ConcurrentCache<AnnotatedType<?>, WBClass<?>> annotatedTypes;
    private final ConcurrentCache<Class<?>, WBAnnotation<?>> annotations;
    private final ClassTransformer transformer = this;
    private final TypeStore typeStore;

    public ClassTransformer(TypeStore typeStore) {
        this.classes = new ConcurrentCache();
        this.annotatedTypes = new ConcurrentCache();
        this.annotations = new ConcurrentCache();
        this.typeStore = typeStore;
    }

    public <T> WBClass<T> loadClass(final Class<T> clazz) {
        return (WBClass)this.classes.putIfAbsent(clazz, new Callable<WBClass<T>>(){

            @Override
            public WBClass<T> call() throws Exception {
                return WBClassImpl.of(clazz, ClassTransformer.this.transformer);
            }
        });
    }

    public <T> WBClass<T> loadClass(final AnnotatedType<T> clazz) {
        return (WBClass)this.annotatedTypes.putIfAbsent(clazz, new Callable<WBClass<T>>(){

            @Override
            public WBClass<T> call() throws Exception {
                return WBClassImpl.of(clazz, ClassTransformer.this.transformer);
            }
        });
    }

    public <T extends Annotation> WBAnnotation<T> loadAnnotation(final Class<T> clazz) {
        return (WBAnnotation)this.annotations.putIfAbsent(clazz, new Callable<WBAnnotation<T>>(){

            @Override
            public WBAnnotation<T> call() throws Exception {
                return WBAnnotationImpl.of(clazz, ClassTransformer.this.transformer);
            }
        });
    }

    public TypeStore getTypeStore() {
        return this.typeStore;
    }
}

