/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.ScopeType;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Initializer;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.deployment.DeploymentType;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisposalMethodBean<T>
extends AbstractBean<T, Method> {
    private static final LogProvider log = Logging.getLogProvider(AbstractProducerBean.class);
    protected AbstractClassBean<?> declaringBean;
    private DisposalMethodBean<?> specializedBean;
    protected MethodInjectionPoint<T> disposalMethodInjectionPoint;
    protected Set<WBInjectionPoint<?, ?>> disposalInjectionPoints;
    private final String id;

    protected DisposalMethodBean(BeanManagerImpl manager, WBMethod<T> disposalMethod, AbstractClassBean<?> declaringBean) {
        super(manager);
        this.disposalMethodInjectionPoint = MethodInjectionPoint.of(this, disposalMethod);
        this.declaringBean = declaringBean;
        this.checkDisposalMethod();
        this.initBindings();
        this.initType();
        this.initTypes();
        this.id = DisposalMethodBean.createId("DisposalMethod-" + declaringBean.getName() + "-" + disposalMethod.getSignature().toString());
    }

    protected void initType() {
        this.type = this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).get(0).getJavaClass();
    }

    public WBMethod<T> getAnnotatedItem() {
        return this.disposalMethodInjectionPoint;
    }

    public static <T> DisposalMethodBean<T> of(BeanManagerImpl manager, WBMethod<T> disposalMethod, AbstractClassBean<?> declaringBean) {
        return new DisposalMethodBean<T>(manager, disposalMethod, declaringBean);
    }

    @Override
    protected void initInjectionPoints() {
        this.disposalInjectionPoints = new HashSet();
        List<ParameterInjectionPoint<?>> disposalMethodParameters = this.disposalMethodInjectionPoint.getParameters();
        if (disposalMethodParameters.size() > 1) {
            for (int i = 1; i < disposalMethodParameters.size(); ++i) {
                WBParameter parameter = disposalMethodParameters.get(i);
                this.disposalInjectionPoints.add(ParameterInjectionPoint.of(this.declaringBean, parameter));
            }
        }
        this.injectionPoints.add(MethodInjectionPoint.of(this.declaringBean, this.disposalMethodInjectionPoint));
    }

    @Override
    protected void initBindings() {
        this.bindings = new HashSet();
        this.bindings.addAll(this.disposalMethodInjectionPoint.getParameters().get(0).getBindings());
        this.initDefaultBindings();
    }

    @Override
    public Class<? extends Annotation> getDeploymentType() {
        return this.declaringBean.getDeploymentType();
    }

    @Override
    protected void initTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types = new HashSet();
        types.addAll(this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).get(0).getTypeClosure());
        types.add(this.getType());
        types.add((Type)((Object)Object.class));
        this.types = types;
    }

    @Override
    public Set<WBInjectionPoint<?, ?>> getAnnotatedInjectionPoints() {
        return this.injectionPoints;
    }

    @Override
    public String getName() {
        return this.disposalMethodInjectionPoint.getPropertyName();
    }

    @Override
    public Class<? extends Annotation> getScopeType() {
        return this.declaringBean.getScopeType();
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public String toString() {
        return this.disposalMethodInjectionPoint.toString();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSerializable() {
        return this.declaringBean.isSerializable();
    }

    @Override
    public boolean isProxyable() {
        return true;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        return null;
    }

    public void invokeDisposeMethod(Object instance, CreationalContext<?> creationalContext) {
        AbstractClassBean<?> beanInstance = this.disposalMethodInjectionPoint.isStatic() ? this.declaringBean : this.getManager().getReference(this.declaringBean, this.declaringBean.getType(), creationalContext);
        this.disposalMethodInjectionPoint.invokeWithSpecialValue(beanInstance, Disposes.class, instance, this.manager, creationalContext, IllegalArgumentException.class);
    }

    private void checkDisposalMethod() {
        if (!this.disposalMethodInjectionPoint.getParameters().get(0).isAnnotationPresent(Disposes.class)) {
            throw new DefinitionException(this.disposalMethodInjectionPoint.toString() + " doesn't have @Dispose as first parameter");
        }
        if (this.disposalMethodInjectionPoint.getAnnotatedParameters(Disposes.class).size() > 1) {
            throw new DefinitionException(this.disposalMethodInjectionPoint.toString() + " has more than one @Dispose parameters");
        }
        if (this.disposalMethodInjectionPoint.getAnnotatedParameters(Observes.class).size() > 0) {
            throw new DefinitionException("@Observes is not allowed on disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.disposalMethodInjectionPoint.getAnnotation(Initializer.class) != null) {
            throw new DefinitionException("@Intitializer is not allowed on a disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.disposalMethodInjectionPoint.getAnnotation(Produces.class) != null) {
            throw new DefinitionException("@Produces is not allowed on a disposal method, see " + this.disposalMethodInjectionPoint.toString());
        }
        if (this.declaringBean instanceof EnterpriseBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.declaringBean.getTypes()) {
                if (!(type instanceof Class)) continue;
                Class clazz = (Class)type;
                try {
                    clazz.getDeclaredMethod(this.disposalMethodInjectionPoint.getName(), this.disposalMethodInjectionPoint.getParameterTypesAsArray());
                    methodDeclaredOnTypes = true;
                }
                catch (NoSuchMethodException nsme) {}
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException("Producer method " + this.toString() + " must be declared on a business interface of " + this.declaringBean);
            }
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        if (this.declaringBean.getAnnotatedItem().getSuperclass().getDeclaredMethod(this.getAnnotatedItem().getAnnotatedMethod()) == null) {
            throw new DefinitionException("Specialized disposal method does not override a method on the direct superclass");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        WBMethod<?> superClassMethod = this.declaringBean.getAnnotatedItem().getSuperclass().getMethod(this.getAnnotatedItem().getAnnotatedMethod());
        if (environment.getProducerMethod(superClassMethod) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        this.specializedBean = environment.getDisposalMethod(superClassMethod);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        return this.declaringBean.getDeploymentType();
    }

    @Override
    protected String getDefaultName() {
        return this.disposalMethodInjectionPoint.getPropertyName();
    }

    @Override
    protected void initDeploymentType() {
        Set<Annotation> deploymentTypes = this.getAnnotatedItem().getMetaAnnotations(DeploymentType.class);
        if (deploymentTypes.size() > 1) {
            throw new DefinitionException("At most one deployment type may be specified (" + deploymentTypes + " are specified) on " + this.getAnnotatedItem().toString());
        }
        if (deploymentTypes.size() == 1) {
            this.deploymentType = deploymentTypes.iterator().next().annotationType();
            log.trace("Deployment type " + this.deploymentType + " specified by annotation");
            return;
        }
        this.initDeploymentTypeFromStereotype();
        if (this.deploymentType == null) {
            this.deploymentType = this.getDefaultDeploymentType();
            log.trace("Using default " + this.deploymentType + " deployment type");
            return;
        }
    }

    @Override
    protected void initScopeType() {
        Set<Annotation> scopeAnnotations = this.getAnnotatedItem().getMetaAnnotations(ScopeType.class);
        if (scopeAnnotations.size() > 1) {
            throw new DefinitionException("At most one scope may be specified");
        }
        if (scopeAnnotations.size() == 1) {
            this.scopeType = scopeAnnotations.iterator().next().annotationType();
            log.trace("Scope " + this.scopeType + " specified by annotation");
            return;
        }
        this.initScopeTypeFromStereotype();
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace("Using default @Dependent scope");
        }
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public String getId() {
        return this.id;
    }
}

