/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.ejb.api.SessionObjectReference;
import org.jboss.webbeans.introspector.MethodSignature;
import org.jboss.webbeans.introspector.jlr.MethodSignatureImpl;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeanProxyMethodHandler<T>
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 2107723373882153667L;
    static final transient Log log = Logging.getLog(EnterpriseBeanProxyMethodHandler.class);
    private static final ThreadLocal<EnterpriseBean<?>> enterpriseBean = new ThreadLocal();
    private static final ThreadLocal<CreationalContext<?>> enterpriseBeanCreationalContext = new ThreadLocal();
    private final SessionObjectReference reference;
    private final Class<?> objectInterface;
    private final Collection<MethodSignature> removeMethodSignatures;
    private final boolean clientCanCallRemoveMethods;
    private boolean destroyed = false;

    public static EnterpriseBean<?> getEnterpriseBean() {
        return enterpriseBean.get();
    }

    public static CreationalContext<?> getEnterpriseBeanCreationalContext() {
        return enterpriseBeanCreationalContext.get();
    }

    private static <T> void setEnterpriseBean(EnterpriseBean<T> bean, CreationalContext<T> creationalContext) {
        enterpriseBean.set(bean);
        enterpriseBeanCreationalContext.set(creationalContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBeanProxyMethodHandler(EnterpriseBean<T> bean, CreationalContext<T> creationalContext) {
        this.objectInterface = bean.getEjbDescriptor().getObjectInterface();
        this.removeMethodSignatures = bean.getEjbDescriptor().getRemoveMethodSignatures();
        this.clientCanCallRemoveMethods = bean.isClientCanCallRemoveMethods();
        try {
            EnterpriseBeanProxyMethodHandler.setEnterpriseBean(bean, creationalContext);
            this.reference = bean.createReference();
        }
        finally {
            EnterpriseBeanProxyMethodHandler.setEnterpriseBean(null, null);
        }
        log.trace((Object)("Created enterprise bean proxy method handler for " + bean), new Object[0]);
    }

    @Override
    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        Object proxiedInstance;
        MethodSignatureImpl methodSignature;
        if ("isDestroyed".equals(method.getName())) {
            return this.destroyed;
        }
        if ("setDestroyed".equals(method.getName())) {
            if (args.length != 1) {
                throw new IllegalArgumentException("enterpriseBeanInstance.setDestroyed() called with >1 argument");
            }
            if (!args[0].getClass().equals(Boolean.TYPE) && !args[0].getClass().equals(Boolean.class)) {
                throw new IllegalArgumentException("enterpriseBeanInstance.setDestroyed() called with non-boolean argument");
            }
            this.destroyed = (Boolean)args[0];
        }
        if (this.destroyed) {
            return null;
        }
        if ("destroy".equals(method.getName())) {
            this.reference.remove();
            return null;
        }
        if (!this.clientCanCallRemoveMethods && this.removeMethodSignatures.contains(methodSignature = new MethodSignatureImpl(method))) {
            throw new UnsupportedOperationException("Cannot call EJB remove method directly on non-dependent scoped bean " + method);
        }
        Class<?> businessInterface = method.getDeclaringClass();
        if (businessInterface.equals(Object.class)) {
            businessInterface = this.objectInterface;
        }
        if ((proxiedInstance = this.reference.getBusinessObject(businessInterface)) == null) {
            throw new IllegalStateException("No EJB can be found in the EJB container for " + this.reference + ". Make sure you are running an EJB container.");
        }
        Method proxiedMethod = Reflections.lookupMethod(method, proxiedInstance);
        Object returnValue = Reflections.invokeAndWrap(proxiedMethod, proxiedInstance, args);
        log.trace((Object)("Executed " + method + " on " + proxiedInstance + " with parameters " + args + " and got return value " + returnValue), new Object[0]);
        return returnValue;
    }
}

