/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Initializer;
import javax.enterprise.inject.Produces;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.NewSimpleBean;
import org.jboss.webbeans.bean.ProducerFieldBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.SimpleBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.event.ObserverFactory;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.jsf.JsfApiAbstraction;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ServletApiAbstraction;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanDeployer {
    private static final LogProvider log = Logging.getLogProvider(AbstractBeanDeployer.class);
    private final BeanManagerImpl manager;
    private final BeanDeployerEnvironment environment;

    public AbstractBeanDeployer(BeanManagerImpl manager, BeanDeployerEnvironment environment) {
        this.manager = manager;
        this.environment = environment;
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    public <T> AbstractBeanDeployer addBean(RIBean<T> bean) {
        this.environment.addBean(bean);
        return this;
    }

    public AbstractBeanDeployer deploy() {
        Set<RIBean<?>> beans = this.environment.getBeans();
        for (DecoratorBean<?> decoratorBean : this.environment.getDecorators()) {
            decoratorBean.initialize(this.environment);
            this.manager.addRIBean(decoratorBean);
            log.debug("Bean: " + decoratorBean);
        }
        for (RIBean rIBean : beans) {
            rIBean.initialize(this.environment);
            this.manager.addRIBean(rIBean);
            log.debug("Bean: " + rIBean);
        }
        for (ObserverImpl observerImpl : this.environment.getObservers()) {
            observerImpl.initialize();
            log.debug("Observer : " + observerImpl);
            this.manager.addObserver(observerImpl);
        }
        return this;
    }

    protected <T> void createSubBeans(AbstractClassBean<T> bean) {
        this.createProducerMethods(bean, (WBClass<?>)bean.getAnnotatedItem());
        this.createProducerFields(bean, (WBClass<?>)bean.getAnnotatedItem());
        this.createObserverMethods((RIBean<?>)bean, (WBClass<?>)bean.getAnnotatedItem());
        this.createDisposalMethods(bean, (WBClass<?>)bean.getAnnotatedItem());
    }

    protected void createProducerMethods(AbstractClassBean<?> declaringBean, WBClass<?> annotatedClass) {
        for (WBMethod<?> method : annotatedClass.getDeclaredAnnotatedMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, method);
        }
    }

    protected void createDisposalMethods(AbstractClassBean<?> declaringBean, WBClass<?> annotatedClass) {
        for (WBMethod<?> method : annotatedClass.getDeclaredMethodsWithAnnotatedParameters(Disposes.class)) {
            DisposalMethodBean<?> disposalBean = DisposalMethodBean.of(this.manager, method, declaringBean);
            this.environment.addDisposalBean(disposalBean);
        }
    }

    protected <T> void createProducerMethod(AbstractClassBean<?> declaringBean, WBMethod<T> annotatedMethod) {
        ProducerMethodBean<T> bean = ProducerMethodBean.of(annotatedMethod, declaringBean, this.manager);
        this.addBean(bean);
    }

    protected <T> void createProducerField(AbstractClassBean<?> declaringBean, WBField<T> field) {
        ProducerFieldBean<T> bean = ProducerFieldBean.of(field, declaringBean, this.manager);
        this.addBean(bean);
    }

    protected void createProducerFields(AbstractClassBean<?> declaringBean, WBClass<?> annotatedClass) {
        for (WBField<?> field : annotatedClass.getDeclaredAnnotatedFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    protected void createObserverMethods(RIBean<?> declaringBean, WBClass<?> annotatedClass) {
        for (WBMethod<?> method : annotatedClass.getDeclaredMethodsWithAnnotatedParameters(Observes.class)) {
            this.createObserverMethod(declaringBean, method);
        }
    }

    protected void createObserverMethod(RIBean<?> declaringBean, WBMethod<?> method) {
        ObserverImpl observer = ObserverFactory.create(method, declaringBean, this.manager);
        this.environment.getObservers().add(observer);
    }

    protected <T> void createSimpleBean(WBClass<T> annotatedClass) {
        SimpleBean<T> bean = SimpleBean.of(annotatedClass, this.manager);
        this.addBean(bean);
        this.createSubBeans(bean);
        this.addBean(NewSimpleBean.of(annotatedClass, this.manager));
    }

    protected <T> void createDecorator(WBClass<T> annotatedClass) {
        DecoratorBean<T> bean = DecoratorBean.of(annotatedClass, this.manager);
        this.addBean(bean);
    }

    protected <T> void createEnterpriseBean(WBClass<T> annotatedClass) {
        EnterpriseBean<T> bean = EnterpriseBean.of(annotatedClass, this.manager, this.environment);
        this.addBean(bean);
        this.createSubBeans(bean);
        this.addBean(NewEnterpriseBean.of(annotatedClass, this.manager, this.environment));
    }

    protected boolean isTypeManagedBeanOrDecorator(WBClass<?> clazz) {
        Class rawType = clazz.getJavaClass();
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        JsfApiAbstraction jsfApiAbstraction = this.manager.getServices().get(JsfApiAbstraction.class);
        ServletApiAbstraction servletApiAbstraction = this.manager.getServices().get(ServletApiAbstraction.class);
        return !clazz.isNonStaticMemberClass() && !Reflections.isParameterizedType(rawType) && !servletApiAbstraction.SERVLET_CLASS.isAssignableFrom(rawType) && !servletApiAbstraction.FILTER_CLASS.isAssignableFrom(rawType) && !servletApiAbstraction.SERVLET_CONTEXT_LISTENER_CLASS.isAssignableFrom(rawType) && !servletApiAbstraction.HTTP_SESSION_LISTENER_CLASS.isAssignableFrom(rawType) && !servletApiAbstraction.SERVLET_REQUEST_LISTENER_CLASS.isAssignableFrom(rawType) && !ejbApiAbstraction.ENTERPRISE_BEAN_CLASS.isAssignableFrom(rawType) && !jsfApiAbstraction.UICOMPONENT_CLASS.isAssignableFrom(rawType) && AbstractBeanDeployer.hasSimpleWebBeanConstructor(clazz);
    }

    private static boolean hasSimpleWebBeanConstructor(WBClass<?> type) {
        return type.getNoArgsConstructor() != null || type.getAnnotatedConstructors(Initializer.class).size() > 0;
    }

    public BeanDeployerEnvironment getBeanDeployerEnvironment() {
        return this.environment;
    }
}

