/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans;

import com.sun.enterprise.deployment.EjbDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.webbeans.BeanDeploymentArchiveImpl;
import org.glassfish.webbeans.WebBeanDiscoveryImpl;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.webbeans.bootstrap.spi.Deployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentImpl
implements Deployment {
    private Logger logger = Logger.getLogger(DeploymentImpl.class.getName());
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar";
    private static final char SEPARATOR_CHAR = '/';
    private final List<Class<?>> wbClasses = new ArrayList();
    private final List<URL> wbUrls = new ArrayList<URL>();
    private final ReadableArchive archive;
    private final List<BeanDeploymentArchive> beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
    private final Collection<EjbDescriptor> ejbs;

    public DeploymentImpl(ReadableArchive archive, Collection<EjbDescriptor> ejbs) {
        this.archive = archive;
        this.ejbs = ejbs;
        this.scan();
    }

    @Override
    public List<BeanDeploymentArchive> getBeanDeploymentArchives() {
        if (this.beanDeploymentArchives.size() > 0) {
            return this.beanDeploymentArchives;
        }
        return Collections.emptyList();
    }

    @Override
    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        return null;
    }

    private void scan() {
        try {
            URL beansXmlUrl;
            String entry;
            Enumeration entries;
            if (this.archive.exists(WEB_INF_BEANS_XML)) {
                entries = this.archive.entries();
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    if (entry.endsWith(CLASS_SUFFIX)) {
                        entry = entry.substring(WEB_INF_CLASSES.length() + 1);
                        String className = DeploymentImpl.filenameToClassname(entry);
                        this.wbClasses.add(this.getClassLoader().loadClass(className));
                        continue;
                    }
                    if (!entry.endsWith("beans.xml")) continue;
                    URI uri = this.archive.getURI();
                    File file = new File(uri.getPath() + entry);
                    beansXmlUrl = file.toURL();
                    this.wbUrls.add(beansXmlUrl);
                }
                this.archive.close();
            }
            if (this.archive.exists(WEB_INF_LIB)) {
                entries = this.archive.entries(WEB_INF_LIB);
                while (entries.hasMoreElements()) {
                    entry = (String)entries.nextElement();
                    if (!entry.endsWith(JAR_SUFFIX) || entry.indexOf(47, WEB_INF_LIB.length() + 1) != -1) continue;
                    ReadableArchive jarArchive = this.archive.getSubArchive(entry);
                    if (jarArchive.exists(META_INF_BEANS_XML)) {
                        Enumeration jarEntries = jarArchive.entries();
                        while (jarEntries.hasMoreElements()) {
                            entry = (String)entries.nextElement();
                            if (entry.endsWith(CLASS_SUFFIX)) {
                                String className = DeploymentImpl.filenameToClassname(entry);
                                this.wbClasses.add(this.getClassLoader().loadClass(className));
                                continue;
                            }
                            if (!entry.endsWith("beans.xml")) continue;
                            beansXmlUrl = WebBeanDiscoveryImpl.class.getResource(entry);
                            this.wbUrls.add(beansXmlUrl);
                        }
                    }
                    jarArchive.close();
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException cne) {
            this.logger.log(Level.SEVERE, cne.getLocalizedMessage(), cne);
        }
        BeanDeploymentArchiveImpl beanDeploymentArchive = new BeanDeploymentArchiveImpl(this.wbClasses, this.wbUrls, this.ejbs);
        this.beanDeploymentArchives.add(beanDeploymentArchive);
    }

    public static String filenameToClassname(String filename) {
        String className = null;
        className = filename.indexOf(File.separatorChar) >= 0 ? filename.replace(File.separatorChar, '.') : filename.replace('/', '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private ClassLoader getClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return DeploymentImpl.class.getClassLoader();
    }
}

