/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.ScopeType;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Initializer;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.deployment.DeploymentType;
import javax.enterprise.inject.deployment.Production;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bean.SerializableBeanInstance;
import org.jboss.webbeans.bean.proxy.DecoratorProxyMethodHandler;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LogProvider log = Logging.getLogProvider(AbstractClassBean.class);
    protected WBClass<T> annotatedItem;
    private Set<FieldInjectionPoint<?>> injectableFields;
    private Set<MethodInjectionPoint<?>> initializerMethods;
    private Set<String> dependencies;
    private List<Decorator<?>> decorators;
    private final String id;
    private Class<T> proxyClassForDecorators;
    private final ThreadLocal<Integer> decoratorStackPosition;

    protected AbstractClassBean(WBClass<T> type, BeanManagerImpl manager) {
        super(manager);
        this.annotatedItem = type;
        this.id = AbstractClassBean.createId(this.getClass().getSimpleName() + "-" + type.getName());
        this.decoratorStackPosition = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.initInitializerMethods();
        super.initialize(environment);
        this.checkBeanImplementation();
        this.initDecorators();
        this.checkType();
        this.initProxyClassForDecoratedBean();
    }

    protected void checkType() {
    }

    protected void initDecorators() {
        this.decorators = this.getManager().resolveDecorators(this.getTypes(), this.getBindings());
    }

    public boolean hasDecorators() {
        return this.decorators != null && this.decorators.size() > 0;
    }

    protected void initProxyClassForDecoratedBean() {
        if (this.hasDecorators()) {
            Class proxyClass;
            LinkedHashSet<Type> types = new LinkedHashSet<Type>(this.getTypes());
            ProxyFactory proxyFactory = Proxies.getProxyFactory(types);
            this.proxyClassForDecorators = proxyClass = proxyFactory.createClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T applyDecorators(T instance, CreationalContext<T> creationalContext) {
        if (this.hasDecorators()) {
            ArrayList<SerializableBeanInstance<DecoratorBean<Object>, Object>> decoratorInstances = new ArrayList<SerializableBeanInstance<DecoratorBean<Object>, Object>>();
            boolean outside = this.decoratorStackPosition.get() == 0;
            try {
                int i = this.decoratorStackPosition.get();
                while (i < this.decorators.size()) {
                    Decorator<?> decorator = this.decorators.get(i);
                    if (decorator instanceof DecoratorBean) {
                        this.decoratorStackPosition.set(++i);
                        decoratorInstances.add(new SerializableBeanInstance<DecoratorBean, Object>((DecoratorBean)decorator, this.getManager().getReference((Bean<?>)decorator, (Type)((Object)Object.class), creationalContext)));
                        continue;
                    }
                    throw new IllegalStateException("Cannot operate on non container provided decorator " + decorator);
                }
            }
            finally {
                if (outside) {
                    this.decoratorStackPosition.remove();
                }
            }
            try {
                T proxy = this.proxyClassForDecorators.newInstance();
                ((ProxyObject)proxy).setHandler(new DecoratorProxyMethodHandler(decoratorInstances, instance));
                return proxy;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not instantiate decorator proxy for " + this.toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not access bean correctly when creating decorator proxy for " + this.toString(), e);
            }
        }
        return instance;
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    protected void injectBoundFields(T instance, CreationalContext<T> creationalContext) {
        for (FieldInjectionPoint<T> fieldInjectionPoint : this.injectableFields) {
            fieldInjectionPoint.inject(instance, this.manager, creationalContext);
        }
    }

    protected void callInitializers(T instance, CreationalContext<T> creationalContext) {
        for (MethodInjectionPoint<T> methodInjectionPoint : this.getInitializerMethods()) {
            methodInjectionPoint.invoke(instance, this.manager, creationalContext, CreationException.class);
        }
    }

    protected void initType() {
        log.trace("Bean type specified in Java");
        this.type = this.getAnnotatedItem().getJavaClass();
        this.dependencies = new HashSet<String>();
        for (Class clazz = this.type.getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.dependencies.add(clazz.getName());
        }
    }

    @Override
    protected void initInjectionPoints() {
        this.injectableFields = new HashSet(Beans.getFieldInjectionPoints(this.annotatedItem, this));
        this.injectionPoints.addAll(this.injectableFields);
        for (MethodInjectionPoint<?> initializer : this.getInitializerMethods()) {
            for (WBParameter<?> parameter : initializer.getParameters()) {
                this.injectionPoints.add(ParameterInjectionPoint.of(this, parameter));
            }
        }
    }

    protected void initInitializerMethods() {
        this.initializerMethods = new HashSet();
        for (WBMethod<?> method : this.annotatedItem.getAnnotatedMethods(Initializer.class)) {
            if (method.isStatic()) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be static on " + this.getAnnotatedItem());
            }
            if (method.getAnnotation(Produces.class) != null) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Produces on " + this.getAnnotatedItem());
            }
            if (method.getAnnotatedParameters(Disposes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot have parameters annotated @Disposes on " + this.getAnnotatedItem());
            }
            if (method.getAnnotatedParameters(Observes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Observes on " + this.getAnnotatedItem());
            }
            this.initializerMethods.add(MethodInjectionPoint.of(this, method));
        }
    }

    @Override
    protected void initScopeType() {
        for (WBClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getSuperclass()) {
            Set<Annotation> scopeTypes = clazz.getDeclaredMetaAnnotations(ScopeType.class);
            scopeTypes = clazz.getDeclaredMetaAnnotations(ScopeType.class);
            if (scopeTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(scopeTypes.iterator().next().annotationType())) break;
                this.scopeType = scopeTypes.iterator().next().annotationType();
                log.trace("Scope " + this.scopeType + " specified by annotation");
                break;
            }
            if (scopeTypes.size() <= 1) continue;
            throw new DefinitionException("At most one scope may be specified on " + this.getAnnotatedItem());
        }
        if (this.scopeType == null) {
            this.initScopeTypeFromStereotype();
        }
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace("Using default @Dependent scope");
        }
    }

    @Override
    protected void initDeploymentType() {
        for (WBClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getSuperclass()) {
            Set<Annotation> deploymentTypes = clazz.getDeclaredMetaAnnotations(DeploymentType.class);
            if (deploymentTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(deploymentTypes.iterator().next().annotationType())) break;
                this.deploymentType = deploymentTypes.iterator().next().annotationType();
                log.trace("Deployment type " + this.deploymentType + " specified by annotation");
                break;
            }
            if (deploymentTypes.size() <= 1) continue;
            throw new DefinitionException("At most one deployment type may be specified");
        }
        if (this.deploymentType == null) {
            this.initDeploymentTypeFromStereotype();
        }
        if (this.deploymentType == null) {
            this.deploymentType = this.getDefaultDeploymentType();
            log.trace("Using default @Production deployment type");
            return;
        }
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getAnnotatedItem().getSuperclass() == null || this.getAnnotatedItem().getSuperclass().getJavaClass().equals(Object.class)) {
            throw new DefinitionException("Specializing bean must extend another bean " + this.toString());
        }
    }

    public WBClass<T> getAnnotatedItem() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Strings.decapitalize(this.getAnnotatedItem().getSimpleName());
        log.trace("Default name of " + this.type + " is " + name);
        return name;
    }

    public Set<? extends MethodInjectionPoint<?>> getInitializerMethods() {
        return this.initializerMethods;
    }

    public Set<String> getSuperclasses() {
        return this.dependencies;
    }

    @Override
    public String toString() {
        return "AbstractClassBean " + this.getName();
    }

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        return Production.class;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

