/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Initializer;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.ForwardingDecorator;
import org.jboss.webbeans.bean.SimpleBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.introspector.WBClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorBean<T>
extends SimpleBean<T>
implements Decorator<T> {
    private WBAnnotated<?, ?> decorates;
    private Set<Annotation> delegateBindings;
    private Type delegateType;
    private Set<Type> delegateTypes;
    private Set<Type> decoratedTypes;

    public static <T> Decorator<T> wrapForResolver(final Decorator<T> decorator) {
        return new ForwardingDecorator<T>(){

            @Override
            public Set<Annotation> getBindings() {
                return this.delegate().getDelegateBindings();
            }

            @Override
            public Set<Type> getTypes() {
                return this.delegate().getTypes();
            }

            @Override
            protected Decorator<T> delegate() {
                return decorator;
            }
        };
    }

    public static <T> DecoratorBean<T> of(WBClass<T> clazz, BeanManagerImpl manager) {
        return new DecoratorBean<T>(clazz, manager);
    }

    protected DecoratorBean(WBClass<T> type, BeanManagerImpl manager) {
        super(type, manager);
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.initDelegate();
            this.initDecoratedTypes();
            this.initDelegateBindings();
            this.initDelegateType();
            this.checkDelegateType();
        }
    }

    protected void initDecoratedTypes() {
        this.decoratedTypes = new HashSet<Type>();
        this.decoratedTypes.addAll(this.getAnnotatedItem().getInterfaceOnlyFlattenedTypeHierarchy());
        this.decoratedTypes.remove(Serializable.class);
    }

    protected void initDelegate() {
        this.decorates = this.getDecoratesInjectionPoint().iterator().next();
    }

    @Override
    protected void checkDecorates() {
        for (WBInjectionPoint<?, ?> injectionPoint : this.getDecoratesInjectionPoint()) {
            if (!(injectionPoint instanceof MethodInjectionPoint) || injectionPoint.isAnnotationPresent(Initializer.class)) continue;
            throw new DefinitionException("Method with @Decorates parameter must be an initializer method " + injectionPoint);
        }
        if (this.getDecoratesInjectionPoint().size() == 0) {
            throw new DefinitionException("No @Decorates injection point defined " + this);
        }
        if (this.getDecoratesInjectionPoint().size() > 1) {
            throw new DefinitionException("Too many @Decorates injection point defined " + this);
        }
    }

    protected void initDelegateBindings() {
        this.delegateBindings = new HashSet<Annotation>();
        this.delegateBindings.addAll(this.decorates.getBindings());
    }

    protected void initDelegateType() {
        this.delegateType = this.decorates.getBaseType();
        this.delegateTypes = new HashSet<Type>();
        this.delegateTypes.add(this.delegateType);
    }

    protected void checkDelegateType() {
        for (Type decoratedType : this.getDecoratedTypes()) {
            Type rawType;
            if (decoratedType instanceof Class) {
                if (((Class)decoratedType).isAssignableFrom(this.decorates.getJavaClass())) continue;
                throw new DefinitionException("The delegate type must extend or implement every decorated type. Decorated type " + decoratedType + "." + this);
            }
            if (!(decoratedType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)decoratedType;
            if (!this.decorates.isParameterizedType()) {
                throw new DefinitionException("The decorated type is parameterized, but the delegate type isn't. Delegate type " + this.delegateType + "." + this);
            }
            if (!Arrays.equals(this.decorates.getActualTypeArguments(), parameterizedType.getActualTypeArguments())) {
                // empty if block
            }
            if ((rawType = ((ParameterizedType)decoratedType).getRawType()) instanceof Class && !((Class)rawType).isAssignableFrom(this.decorates.getJavaClass())) {
                throw new DefinitionException("The delegate type must extend or implement every decorated type. Decorated type " + decoratedType + "." + this);
            }
            throw new IllegalStateException("Unable to process " + decoratedType);
        }
    }

    @Override
    public Set<Annotation> getDelegateBindings() {
        return this.delegateBindings;
    }

    @Override
    public Type getDelegateType() {
        return this.delegateType;
    }

    @Override
    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }

    public Set<Type> getDelegateTypes() {
        return this.delegateTypes;
    }

    @Override
    protected void initDecorators() {
    }
}

