/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.ejb;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.webbeans.ejb.InternalEjbDescriptor;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDescriptorCache {
    private Map<Class<?>, Set<InternalEjbDescriptor<?>>> ejbsByBeanClass = new HashMap();

    public <T> Iterable<InternalEjbDescriptor<T>> get(Class<T> beanClass) {
        return this.ejbsByBeanClass.get(beanClass);
    }

    public <T> void add(EjbDescriptor<T> ejbDescriptor) {
        InternalEjbDescriptor<T> internalEjbDescriptor = new InternalEjbDescriptor<T>(ejbDescriptor);
        if (!this.ejbsByBeanClass.containsKey(ejbDescriptor.getBeanClass())) {
            this.ejbsByBeanClass.put(ejbDescriptor.getBeanClass(), new CopyOnWriteArraySet());
        }
        this.ejbsByBeanClass.get(ejbDescriptor.getBeanClass()).add(internalEjbDescriptor);
    }

    public boolean containsKey(Class<?> beanClass) {
        return this.ejbsByBeanClass.containsKey(beanClass);
    }

    public void addAll(Iterable<EjbDescriptor<?>> ejbDescriptors) {
        for (EjbDescriptor<?> ejbDescriptor : ejbDescriptors) {
            this.add(ejbDescriptor);
        }
    }

    public void clear() {
        this.ejbsByBeanClass.clear();
    }

    public String toString() {
        return "EJB Descriptor cache has indexed " + this.ejbsByBeanClass.size() + " EJBs by class";
    }
}

