/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousTransactionalEventNotification<T>
extends DeferredEventNotification<T> {
    private static Log log = Logging.getLog(DeferredEventNotification.class);

    public AsynchronousTransactionalEventNotification(T event, ObserverImpl<T> observer) {
        super(event, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DependentContext.instance().setActive(true);
        try {
            log.trace((Object)("Sending event [" + this.event + "] asynchronously to transaction observer " + this.observer), new Object[0]);
            this.observer.sendEventAsynchronously(this.event);
        }
        catch (Exception e) {
            log.error((Object)("Failure while queuing observer for event [" + this.event + "]"), e, new Object[0]);
        }
        finally {
            DependentContext.instance().setActive(false);
        }
    }
}

