/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.ConstructorSignature;
import org.jboss.webbeans.introspector.WBConstructor;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.introspector.WBType;
import org.jboss.webbeans.introspector.jlr.AbstractWBMember;
import org.jboss.webbeans.introspector.jlr.ConstructorSignatureImpl;
import org.jboss.webbeans.introspector.jlr.WBParameterImpl;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBConstructorImpl<T>
extends AbstractWBMember<T, Constructor<T>>
implements WBConstructor<T> {
    private final Constructor<T> constructor;
    private final List<WBParameter<?>> parameters;
    private final ListMultimap<Class<? extends Annotation>, WBParameter<?>> annotatedParameters;
    private final WBType<T> declaringClass;
    private final ConstructorSignature signature;
    private String toString;

    public static <T> WBConstructor<T> of(Constructor<T> constructor, WBType<T> declaringClass, ClassTransformer classTransformer) {
        return new WBConstructorImpl<T>(constructor, declaringClass, classTransformer);
    }

    protected WBConstructorImpl(Constructor<T> constructor, WBType<T> declaringClass, ClassTransformer classTransformer) {
        super(AnnotationStore.of(constructor, classTransformer.getTypeStore()), constructor, constructor.getDeclaringClass(), constructor.getDeclaringClass());
        this.constructor = constructor;
        this.declaringClass = declaringClass;
        this.parameters = new ArrayList();
        this.annotatedParameters = Multimaps.newListMultimap(new HashMap(), new Supplier<List<WBParameter<?>>>(){

            @Override
            public List<WBParameter<?>> get() {
                return new ArrayList();
            }
        });
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            WBParameter<?> parameter;
            Type type;
            Class<?> clazz;
            if (constructor.getParameterAnnotations()[i].length > 0) {
                clazz = constructor.getParameterTypes()[i];
                type = constructor.getGenericParameterTypes()[i];
                parameter = WBParameterImpl.of(constructor.getParameterAnnotations()[i], clazz, type, this, classTransformer);
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotations()) {
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = constructor.getParameterTypes()[i];
            type = constructor.getGenericParameterTypes().length > i ? constructor.getGenericParameterTypes()[i] : clazz;
            parameter = WBParameterImpl.of(new Annotation[0], clazz, type, this, classTransformer);
            this.parameters.add(parameter);
            for (Annotation annotation : parameter.getAnnotations()) {
                this.annotatedParameters.put(annotation.annotationType(), parameter);
            }
        }
        this.signature = new ConstructorSignatureImpl(this);
    }

    public Constructor<T> getAnnotatedConstructor() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getDelegate() {
        return this.constructor;
    }

    @Override
    public List<WBParameter<?>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<WBParameter<?>> getAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList(this.annotatedParameters.get(annotationType));
    }

    @Override
    public T newInstance(Object ... parameters) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ((Constructor)this.getDelegate()).newInstance(parameters);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof WBConstructor) {
            WBConstructor that = (WBConstructor)other;
            return this.getDeclaringType().equals(that.getDeclaringType()) && ((Object)this.getParameters()).equals(that.getParameters());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Constructor)this.getDelegate()).hashCode();
    }

    @Override
    public WBType<T> getDeclaringType() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated constructor " + Names.constructorToString(this.constructor);
        return this.toString;
    }

    @Override
    public ConstructorSignature getSignature() {
        return this.signature;
    }
}

