/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.literal.CurrentLiteral;
import org.jboss.webbeans.resolution.Resolvable;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvableFactory {
    public static Resolvable of(WBAnnotated<?, ?> element) {
        if (element instanceof Resolvable) {
            return (Resolvable)((Object)element);
        }
        HashSet<Type> types = new HashSet<Type>();
        types.add(element.getBaseType());
        return new ResolvableImpl(element.getBindings(), types);
    }

    public static Resolvable of(Set<Type> typeClosure, Set<Annotation> bindings) {
        return new ResolvableImpl(bindings, typeClosure);
    }

    public static Resolvable of(Set<Type> typeClosure, Annotation ... bindings) {
        return new ResolvableImpl(new HashSet<Annotation>(Arrays.asList(bindings)), typeClosure);
    }

    private ResolvableFactory() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvableImpl
    implements Resolvable {
        private final Set<Annotation> bindings;
        private final Set<Class<? extends Annotation>> annotationTypes;
        private final Set<Type> typeClosure;

        public ResolvableImpl(Set<Annotation> bindings, Set<Type> typeClosure) {
            this.bindings = bindings;
            if (bindings.size() == 0) {
                this.bindings.add(new CurrentLiteral());
            }
            this.annotationTypes = new HashSet<Class<? extends Annotation>>();
            this.typeClosure = typeClosure;
            for (Annotation annotation : bindings) {
                this.annotationTypes.add(annotation.annotationType());
            }
        }

        @Override
        public Set<Annotation> getBindings() {
            return this.bindings;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotationTypes.contains(annotationType);
        }

        @Override
        public Set<Type> getTypeClosure() {
            return this.typeClosure;
        }

        @Override
        public boolean isAssignableTo(Class<?> clazz) {
            return Reflections.isAssignableFrom(clazz, this.typeClosure);
        }

        public String toString() {
            return "Types: " + this.getTypeClosure() + "; Bindings: " + this.getBindings();
        }
    }
}

