/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resolution;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jboss.webbeans.resolution.ForwardingResolvable;
import org.jboss.webbeans.resolution.Resolvable;
import org.jboss.webbeans.resolution.ResolvableTransformer;
import org.jboss.webbeans.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeSafeResolver<T> {
    private static final long serialVersionUID = 1L;
    private ConcurrentCache<MatchingResolvable, Set<T>> resolved;
    private final Iterable<? extends T> iterable;

    public TypeSafeResolver(Iterable<? extends T> allBeans) {
        this.iterable = allBeans;
        this.resolved = new ConcurrentCache();
    }

    public void clear() {
        this.resolved = new ConcurrentCache();
    }

    public Set<T> resolve(Resolvable key) {
        final MatchingResolvable resolvable = MatchingResolvable.of(this.transform(key));
        Callable callable = new Callable<Set<T>>(){

            @Override
            public Set<T> call() throws Exception {
                return TypeSafeResolver.this.sortResult(TypeSafeResolver.this.filterResult(TypeSafeResolver.this.findMatching(resolvable)));
            }
        };
        Set beans = (Set)this.resolved.putIfAbsent(resolvable, callable);
        return Collections.unmodifiableSet(beans);
    }

    protected Resolvable transform(Resolvable resolvable) {
        for (ResolvableTransformer transformer : this.getTransformers()) {
            resolvable = transformer.transform(resolvable);
        }
        return resolvable;
    }

    protected abstract Iterable<ResolvableTransformer> getTransformers();

    protected abstract Set<T> filterResult(Set<T> var1);

    protected abstract Set<T> sortResult(Set<T> var1);

    private Set<T> findMatching(MatchingResolvable resolvable) {
        HashSet<T> result = new HashSet<T>();
        for (T bean : this.iterable) {
            if (!this.matches(resolvable, bean)) continue;
            result.add(bean);
        }
        return result;
    }

    protected abstract boolean matches(Resolvable var1, T var2);

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved injection points: " + this.resolved.size() + "\n");
        return buffer.toString();
    }

    private static abstract class MatchingResolvable
    extends ForwardingResolvable {
        private MatchingResolvable() {
        }

        public static MatchingResolvable of(final Resolvable resolvable) {
            return new MatchingResolvable(){

                protected Resolvable delegate() {
                    return resolvable;
                }
            };
        }

        public boolean equals(Object obj) {
            if (obj instanceof Resolvable) {
                Resolvable that = (Resolvable)obj;
                return ((Object)this.getTypeClosure()).equals(that.getTypeClosure()) && ((Object)this.getBindings()).equals(that.getBindings());
            }
            return false;
        }
    }
}

