/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.ELResolver;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Qualifier;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.DeploymentException;
import org.jboss.webbeans.SimpleInjectionTarget;
import org.jboss.webbeans.Validator;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.proxy.ClientProxyProvider;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.CreationalContextImpl;
import org.jboss.webbeans.context.WBCreationalContext;
import org.jboss.webbeans.ejb.EjbDescriptors;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;
import org.jboss.webbeans.el.Namespace;
import org.jboss.webbeans.el.WebBeansELResolver;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.literal.AnyLiteral;
import org.jboss.webbeans.literal.DefaultLiteral;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.manager.api.WebBeansManager;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.metadata.cache.ScopeModel;
import org.jboss.webbeans.resolution.NameBasedResolver;
import org.jboss.webbeans.resolution.ResolvableFactory;
import org.jboss.webbeans.resolution.ResolvableWBClass;
import org.jboss.webbeans.resolution.TypeSafeBeanResolver;
import org.jboss.webbeans.resolution.TypeSafeDecoratorResolver;
import org.jboss.webbeans.resolution.TypeSafeObserverResolver;
import org.jboss.webbeans.resolution.TypeSafeResolver;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManagerImpl
implements WebBeansManager,
Serializable {
    private static final Log log = Logging.getLog(BeanManagerImpl.class);
    private static final long serialVersionUID = 3021562879133838561L;
    public static final String JNDI_KEY = "java:app/Manager";
    private final transient ExecutorService taskExecutor = Executors.newSingleThreadExecutor();
    private final transient ServiceRegistry services;
    private final transient ListMultimap<Class<? extends Annotation>, Context> contexts;
    private final transient ClientProxyProvider clientProxyProvider;
    private final transient AtomicInteger ids;
    private final transient Map<String, RIBean<?>> riBeans;
    private final transient Map<EjbDescriptor<?>, EnterpriseBean<?>> enterpriseBeans;
    private final transient Map<Contextual<?>, Contextual<?>> specializedBeans;
    private transient Collection<Class<?>> enabledPolicyClasses;
    private transient Collection<Class<? extends Annotation>> enabledPolicyStereotypes;
    private transient List<Class<?>> enabledDecoratorClasses;
    private transient List<Class<?>> enabledInterceptorClasses;
    private final transient Set<CurrentActivity> currentActivities;
    private final transient TypeSafeBeanResolver<Bean<?>> beanResolver;
    private final transient TypeSafeResolver<DecoratorBean<?>> decoratorResolver;
    private final transient TypeSafeResolver<ObserverMethod<?, ?>> observerResolver;
    private final transient NameBasedResolver nameBasedResolver;
    private final transient ELResolver webbeansELResolver;
    private transient Namespace rootNamespace;
    private final transient List<Bean<?>> beans;
    private final transient List<DecoratorBean<?>> decorators;
    private final transient List<String> namespaces;
    private final transient List<ObserverMethod<?, ?>> observers;
    private final transient HashSet<BeanManagerImpl> accessibleManagers;
    private final transient Set<BeanManagerImpl> childActivities;
    private final Integer id;
    private final transient ThreadLocal<Stack<InjectionPoint>> currentInjectionPoint;

    public static BeanManagerImpl newRootManager(ServiceRegistry serviceRegistry) {
        ListMultimap<Class<? extends Annotation>, Context> contexts = Multimaps.newListMultimap(new ConcurrentHashMap(), new Supplier<List<Context>>(){

            @Override
            public List<Context> get() {
                return new CopyOnWriteArrayList<Context>();
            }
        });
        return new BeanManagerImpl(serviceRegistry, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), new ConcurrentHashMap(), new ConcurrentHashMap(), new ClientProxyProvider(), contexts, new CopyOnWriteArraySet<CurrentActivity>(), new HashMap(), new ArrayList(), new ArrayList<Class<? extends Annotation>>(), new ArrayList(), new AtomicInteger());
    }

    public static BeanManagerImpl newManager(BeanManagerImpl rootManager, ServiceRegistry services) {
        return new BeanManagerImpl(services, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), rootManager.getEnterpriseBeans(), new ConcurrentHashMap(), rootManager.getClientProxyProvider(), rootManager.getContexts(), new CopyOnWriteArraySet<CurrentActivity>(), new HashMap(), new ArrayList(), new ArrayList<Class<? extends Annotation>>(), new ArrayList(), rootManager.getIds());
    }

    public static BeanManagerImpl newChildActivityManager(BeanManagerImpl parentManager) {
        CopyOnWriteArrayList beans = new CopyOnWriteArrayList();
        beans.addAll(parentManager.getBeans());
        CopyOnWriteArrayList registeredObservers = new CopyOnWriteArrayList();
        registeredObservers.addAll(parentManager.getObservers());
        CopyOnWriteArrayList<String> namespaces = new CopyOnWriteArrayList<String>();
        namespaces.addAll(parentManager.getNamespaces());
        return new BeanManagerImpl(parentManager.getServices(), beans, parentManager.getDecorators(), registeredObservers, namespaces, parentManager.getEnterpriseBeans(), parentManager.getRiBeans(), parentManager.getClientProxyProvider(), parentManager.getContexts(), parentManager.getCurrentActivities(), parentManager.getSpecializedBeans(), parentManager.getEnabledPolicyClasses(), parentManager.getEnabledPolicyStereotypes(), parentManager.getEnabledDecoratorClasses(), parentManager.getIds());
    }

    private BeanManagerImpl(ServiceRegistry serviceRegistry, List<Bean<?>> beans, List<DecoratorBean<?>> decorators, List<ObserverMethod<?, ?>> observers, List<String> namespaces, Map<EjbDescriptor<?>, EnterpriseBean<?>> enterpriseBeans, Map<String, RIBean<?>> riBeans, ClientProxyProvider clientProxyProvider, ListMultimap<Class<? extends Annotation>, Context> contexts, Set<CurrentActivity> currentActivities, Map<Contextual<?>, Contextual<?>> specializedBeans, Collection<Class<?>> enabledPolicyClasses, Collection<Class<? extends Annotation>> enabledPolicyStereotypes, List<Class<?>> enabledDecoratorClasses, AtomicInteger ids) {
        this.services = serviceRegistry;
        this.beans = beans;
        this.decorators = decorators;
        this.enterpriseBeans = enterpriseBeans;
        this.riBeans = riBeans;
        this.clientProxyProvider = clientProxyProvider;
        this.contexts = contexts;
        this.currentActivities = currentActivities;
        this.specializedBeans = specializedBeans;
        this.observers = observers;
        this.enabledPolicyClasses = enabledPolicyClasses;
        this.enabledPolicyStereotypes = enabledPolicyStereotypes;
        this.setEnabledDecoratorClasses(enabledDecoratorClasses);
        this.namespaces = namespaces;
        this.ids = ids;
        this.id = ids.incrementAndGet();
        this.accessibleManagers = new HashSet();
        this.beanResolver = new TypeSafeBeanResolver(this, this.createDynamicAccessibleIterable(Transform.BEAN));
        this.decoratorResolver = new TypeSafeDecoratorResolver(this, this.createDynamicAccessibleIterable(Transform.DECORATOR_BEAN));
        this.observerResolver = new TypeSafeObserverResolver(this, this.createDynamicAccessibleIterable(Transform.EVENT_OBSERVER));
        this.nameBasedResolver = new NameBasedResolver(this, this.createDynamicAccessibleIterable(Transform.BEAN));
        this.webbeansELResolver = new WebBeansELResolver(this);
        this.childActivities = new CopyOnWriteArraySet<BeanManagerImpl>();
        this.currentInjectionPoint = new ThreadLocal<Stack<InjectionPoint>>(){

            @Override
            protected Stack<InjectionPoint> initialValue() {
                return new Stack<InjectionPoint>();
            }
        };
    }

    private <T> Set<Iterable<T>> buildAccessibleClosure(Collection<BeanManagerImpl> hierarchy, Transform<T> transform) {
        HashSet<Iterable<T>> result = new HashSet<Iterable<T>>();
        hierarchy.add(this);
        result.add(transform.transform(this));
        for (BeanManagerImpl beanManager : this.accessibleManagers) {
            if (hierarchy.contains(beanManager)) continue;
            result.addAll(beanManager.buildAccessibleClosure(new ArrayList<BeanManagerImpl>(hierarchy), transform));
        }
        return result;
    }

    private <T> Iterable<T> createDynamicAccessibleIterable(final Transform<T> transform) {
        return new Iterable<T>(){
            private Function<Iterable<T>, Iterator<T>> function = new Function<Iterable<T>, Iterator<T>>(){

                @Override
                public Iterator<T> apply(Iterable<T> iterable) {
                    return iterable.iterator();
                }
            };

            @Override
            public Iterator<T> iterator() {
                Set iterable = BeanManagerImpl.this.buildAccessibleClosure(new ArrayList(), transform);
                return Iterators.concat(Iterators.transform(iterable.iterator(), this.function));
            }
        };
    }

    private <T> Iterable<T> createStaticAccessibleIterable(Transform<T> transform) {
        Set<Iterable<T>> iterable = this.buildAccessibleClosure(new ArrayList<BeanManagerImpl>(), transform);
        return Iterables.concat(iterable);
    }

    public void addAccessibleBeanManager(BeanManagerImpl accessibleBeanManager) {
        this.accessibleManagers.add(accessibleBeanManager);
        this.beanResolver.clear();
    }

    protected Set<BeanManagerImpl> getAccessibleManagers() {
        return this.accessibleManagers;
    }

    @Override
    public void addBean(Bean<?> bean) {
        if (this.beans.contains(bean)) {
            return;
        }
        if (bean.getClass().equals(EnterpriseBean.class)) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)bean;
            this.enterpriseBeans.put(enterpriseBean.getEjbDescriptor(), enterpriseBean);
        }
        if (bean instanceof RIBean) {
            RIBean riBean = (RIBean)bean;
            this.riBeans.put(riBean.getId(), riBean);
        }
        this.registerBeanNamespace(bean);
        for (BeanManagerImpl childActivity : this.childActivities) {
            childActivity.addBean(bean);
        }
        this.beans.add(bean);
        this.beanResolver.clear();
    }

    public void addDecorator(DecoratorBean<?> bean) {
        this.decorators.add(bean);
        this.riBeans.put(bean.getId(), bean);
        this.decoratorResolver.clear();
    }

    @Override
    public <T> Set<ObserverMethod<?, T>> resolveObserverMethods(T event, Annotation ... bindings) {
        this.checkBindingTypes(Arrays.asList(bindings));
        Class<?> clazz = event.getClass();
        HashSet<Annotation> bindingAnnotations = new HashSet<Annotation>(Arrays.asList(bindings));
        if (bindingAnnotations.size() == 0) {
            bindingAnnotations.add(new DefaultLiteral());
        }
        bindingAnnotations.add(new AnyLiteral());
        this.checkEventType(clazz);
        HashSet observers = new HashSet();
        Set<ObserverMethod<?, ?>> eventObservers = this.observerResolver.resolve(ResolvableFactory.of(new Reflections.HierarchyDiscovery(clazz).getFlattenedTypes(), bindingAnnotations, null));
        for (ObserverMethod<?, ?> observer : eventObservers) {
            observers.add(observer);
        }
        return observers;
    }

    private void checkBindingTypes(Collection<Annotation> bindings) {
        HashSet<Annotation> bindingAnnotations = new HashSet<Annotation>(bindings);
        for (Annotation annotation : bindings) {
            if (this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        if (bindingAnnotations.size() < bindings.size()) {
            throw new IllegalArgumentException("Duplicate binding types: " + bindings);
        }
    }

    private void checkEventType(Type eventType) {
        Type[] types;
        Type resolvedType = new Reflections.HierarchyDiscovery(eventType).getResolvedType();
        if (resolvedType instanceof Class) {
            types = new Type[]{};
        } else if (resolvedType instanceof ParameterizedType) {
            types = ((ParameterizedType)resolvedType).getActualTypeArguments();
        } else {
            throw new IllegalArgumentException("Event type " + resolvedType + " is not allowed");
        }
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot provide an event type parameterized with a type parameter " + resolvedType);
        }
    }

    public Collection<Class<?>> getEnabledPolicyClasses() {
        return Collections.unmodifiableCollection(this.enabledPolicyClasses);
    }

    public Collection<Class<? extends Annotation>> getEnabledPolicyStereotypes() {
        return Collections.unmodifiableCollection(this.enabledPolicyStereotypes);
    }

    public boolean isBeanEnabled(Bean<?> bean) {
        return Beans.isBeanEnabled(bean, this.getEnabledPolicyClasses(), this.getEnabledPolicyStereotypes());
    }

    public List<Class<?>> getEnabledDecoratorClasses() {
        return Collections.unmodifiableList(this.enabledDecoratorClasses);
    }

    public List<Class<?>> getEnabledInterceptorClasses() {
        return Collections.unmodifiableList(this.enabledInterceptorClasses);
    }

    public void setEnabledPolicyClasses(Collection<Class<?>> enabledPolicyClasses) {
        this.enabledPolicyClasses = enabledPolicyClasses;
    }

    public void setEnabledPolicyStereotypes(Collection<Class<? extends Annotation>> enabledPolicySterotypes) {
        this.enabledPolicyStereotypes = enabledPolicySterotypes;
    }

    public void setEnabledDecoratorClasses(List<Class<?>> enabledDecoratorClasses) {
        this.enabledDecoratorClasses = enabledDecoratorClasses;
    }

    public void setEnabledInterceptorClasses(List<Class<?>> enabledInterceptorClasses) {
        this.enabledInterceptorClasses = enabledInterceptorClasses;
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... bindings) {
        return this.getBeans(ResolvableWBClass.of(beanType, bindings, this), bindings);
    }

    public Set<Bean<?>> getBeans(WBAnnotated<?, ?> element, Annotation ... bindings) {
        for (Annotation annotation : element.getAnnotations()) {
            if (this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        if (bindings != null && bindings.length > element.getMetaAnnotations(Qualifier.class).size()) {
            throw new IllegalArgumentException("Duplicate bindings (" + Arrays.asList(bindings) + ") type passed " + element.toString());
        }
        return this.beanResolver.resolve(ResolvableFactory.of(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Bean<?>> getInjectableBeans(InjectionPoint injectionPoint) {
        boolean registerInjectionPoint = !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().push(injectionPoint);
            }
            Set<Bean<?>> beans = this.getBeans(ResolvableWBClass.of(injectionPoint.getType(), injectionPoint.getQualifiers().toArray(new Annotation[0]), this), new Annotation[0]);
            HashSet injectableBeans = new HashSet();
            for (Bean<?> bean : beans) {
                if (bean instanceof Decorator || bean instanceof Interceptor) continue;
                injectableBeans.add(bean);
            }
            HashSet hashSet = injectableBeans;
            return hashSet;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().pop();
            }
        }
    }

    protected void registerBeanNamespace(Bean<?> bean) {
        if (bean.getName() != null && bean.getName().indexOf(46) > 0) {
            this.namespaces.add(bean.getName().substring(0, bean.getName().lastIndexOf(46)));
        }
    }

    public Map<EjbDescriptor<?>, EnterpriseBean<?>> getEnterpriseBeans() {
        return this.enterpriseBeans;
    }

    public List<Bean<?>> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    public List<DecoratorBean<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    public Iterable<Bean<?>> getAccessibleBeans() {
        return this.createDynamicAccessibleIterable(Transform.BEAN);
    }

    public Map<String, RIBean<?>> getRiBeans() {
        return Collections.unmodifiableMap(this.riBeans);
    }

    public void addContext(Context context) {
        this.contexts.put(context.getScope(), context);
    }

    public void addObserver(ObserverMethod<?, ?> observer) {
        this.observers.add(observer);
        log.trace((Object)("Added observer " + observer), new Object[0]);
        for (BeanManagerImpl childActivity : this.childActivities) {
            childActivity.addObserver(observer);
        }
    }

    @Override
    public void fireEvent(Object event, Annotation ... bindings) {
        this.notifyObservers(event, this.resolveObserverMethods(event, bindings));
    }

    private <T> void notifyObservers(T event, Set<ObserverMethod<?, T>> observers) {
        for (ObserverMethod<?, T> observer : observers) {
            observer.notify(event);
        }
    }

    @Override
    public Context getContext(Class<? extends Annotation> scopeType) {
        ArrayList<Context> activeContexts = new ArrayList<Context>();
        for (Context context : this.contexts.get(scopeType)) {
            if (!context.isActive()) continue;
            activeContexts.add(context);
        }
        if (activeContexts.isEmpty()) {
            throw new ContextNotActiveException("No active contexts for scope type " + scopeType.getName());
        }
        if (activeContexts.size() > 1) {
            throw new IllegalStateException("More than one context active for scope type " + scopeType.getName());
        }
        return (Context)activeContexts.iterator().next();
    }

    public Object getReference(Bean<?> bean, CreationalContext<?> creationalContext) {
        bean = this.getMostSpecializedBean(bean);
        if (creationalContext instanceof WBCreationalContext) {
            creationalContext = ((WBCreationalContext)creationalContext).getCreationalContext(bean);
        }
        if (this.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal()) {
            if (creationalContext != null || creationalContext == null && this.getContext(bean.getScope()).get(bean) != null) {
                return this.clientProxyProvider.getClientProxy(this, bean);
            }
            return null;
        }
        return this.getContext(bean.getScope()).get(bean, creationalContext);
    }

    @Override
    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        if (!Reflections.isAssignableFrom(bean.getTypes(), beanType)) {
            throw new IllegalArgumentException("The given beanType is not a type " + beanType + " of the bean " + bean);
        }
        return this.getReference(bean, creationalContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReference(InjectionPoint injectionPoint, Bean<?> resolvedBean, CreationalContext<?> creationalContext) {
        boolean registerInjectionPoint = injectionPoint != null && !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().push(injectionPoint);
            }
            if (this.getServices().get(MetaAnnotationStore.class).getScopeModel(resolvedBean.getScope()).isNormal() && !Proxies.isTypeProxyable(injectionPoint.getType())) {
                throw new UnproxyableResolutionException("Attempting to inject an unproxyable normal scoped bean " + resolvedBean + " into " + injectionPoint);
            }
            if (creationalContext instanceof WBCreationalContext) {
                WBCreationalContext wbCreationalContext = (WBCreationalContext)creationalContext;
                if (wbCreationalContext.containsIncompleteInstance(resolvedBean)) {
                    Object obj = wbCreationalContext.getIncompleteInstance(resolvedBean);
                    return obj;
                }
                Object object = this.getReference(resolvedBean, wbCreationalContext);
                return object;
            }
            Object object = this.getReference(resolvedBean, creationalContext);
            return object;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().pop();
            }
        }
    }

    @Override
    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        WBAnnotated element = ResolvableWBClass.of(injectionPoint.getType(), injectionPoint.getQualifiers().toArray(new Annotation[0]), this);
        Bean resolvedBean = this.getBean(element, element.getBindingsAsArray());
        return this.getReference(injectionPoint, resolvedBean, creationalContext);
    }

    @Deprecated
    public <T> T getInstanceByType(Class<T> beanType, Annotation ... bindings) {
        Object reference;
        Set beans = this.getBeans(beanType, bindings);
        Bean bean = this.resolve(beans);
        Object instance = reference = this.getReference(bean, beanType, this.createCreationalContext((Contextual)bean));
        return (T)instance;
    }

    public <T> Bean<T> getBean(WBAnnotated<T, ?> element, Annotation ... bindings) {
        Bean bean = this.resolve(this.getBeans(element, bindings));
        if (bean == null) {
            throw new UnsatisfiedResolutionException(element + "Unable to resolve any Web Beans");
        }
        boolean normalScoped = this.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw new UnproxyableResolutionException("Normal scoped bean " + bean + " is not proxyable");
        }
        return bean;
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        return this.nameBasedResolver.resolve(name);
    }

    @Override
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... bindings) {
        this.checkResolveDecoratorsArguments(types, Arrays.asList(bindings));
        return new ArrayList(this.decoratorResolver.resolve(ResolvableFactory.of(types, null, bindings)));
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Set<Annotation> bindings) {
        this.checkResolveDecoratorsArguments(types, bindings);
        return new ArrayList(this.decoratorResolver.resolve(ResolvableFactory.of(types, bindings, null)));
    }

    private void checkResolveDecoratorsArguments(Set<Type> types, Collection<Annotation> bindings) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException("No decorator types were specified in the set");
        }
        this.checkBindingTypes(bindings);
    }

    @Override
    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        throw new UnsupportedOperationException();
    }

    public TypeSafeBeanResolver<Bean<?>> getBeanResolver() {
        return this.beanResolver;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Manager\n");
        buffer.append("Enabled policies: " + this.getEnabledPolicyClasses() + " " + this.getEnabledPolicyStereotypes() + "\n");
        buffer.append("Registered contexts: " + this.contexts.keySet() + "\n");
        buffer.append("Registered beans: " + this.getBeans().size() + "\n");
        buffer.append("Specialized beans: " + this.specializedBeans.size() + "\n");
        return buffer.toString();
    }

    @Override
    public BeanManagerImpl createActivity() {
        BeanManagerImpl childActivity = BeanManagerImpl.newChildActivityManager(this);
        this.childActivities.add(childActivity);
        CurrentManager.add(childActivity);
        return childActivity;
    }

    @Override
    public BeanManagerImpl setCurrent(Class<? extends Annotation> scopeType) {
        if (!this.getServices().get(MetaAnnotationStore.class).getScopeModel(scopeType).isNormal()) {
            throw new IllegalArgumentException("Scope must be a normal scope type " + scopeType);
        }
        this.currentActivities.add(new CurrentActivity(this.getContext(scopeType), this));
        return this;
    }

    public BeanManagerImpl getCurrent() {
        ArrayList<CurrentActivity> activeCurrentActivities = new ArrayList<CurrentActivity>();
        for (CurrentActivity currentActivity : this.currentActivities) {
            if (!currentActivity.getContext().isActive()) continue;
            activeCurrentActivities.add(currentActivity);
        }
        if (activeCurrentActivities.size() == 0) {
            return this;
        }
        if (activeCurrentActivities.size() == 1) {
            return ((CurrentActivity)activeCurrentActivities.get(0)).getManager();
        }
        throw new IllegalStateException("More than one current activity for an active context " + this.currentActivities);
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public InjectionPoint getCurrentInjectionPoint() {
        if (!this.currentInjectionPoint.get().empty()) {
            return this.currentInjectionPoint.get().peek();
        }
        return null;
    }

    public InjectionPoint replaceOrPushCurrentInjectionPoint(InjectionPoint injectionPoint) {
        InjectionPoint originalInjectionPoint = null;
        if (!this.currentInjectionPoint.get().empty()) {
            originalInjectionPoint = this.currentInjectionPoint.get().pop();
        } else {
            log.trace((Object)"No current injection point to replace #0", injectionPoint);
        }
        this.currentInjectionPoint.get().push(injectionPoint);
        return originalInjectionPoint;
    }

    public Map<Contextual<?>, Contextual<?>> getSpecializedBeans() {
        return this.specializedBeans;
    }

    protected Object readResolve() {
        return CurrentManager.get(this.id);
    }

    public ExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    public void shutdown() {
        log.trace((Object)"Ending application", new Object[0]);
        this.shutdownExecutors();
        ApplicationContext applicationContext = this.getServices().get(ApplicationContext.class);
        applicationContext.destroy();
        applicationContext.setActive(false);
        applicationContext.setBeanStore(null);
        CurrentManager.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void shutdownExecutors() {
        this.taskExecutor.shutdown();
        try {
            if (this.taskExecutor.awaitTermination(60L, TimeUnit.SECONDS)) return;
            this.taskExecutor.shutdownNow();
            if (this.taskExecutor.awaitTermination(60L, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException ie) {
            this.taskExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected ClientProxyProvider getClientProxyProvider() {
        return this.clientProxyProvider;
    }

    protected ListMultimap<Class<? extends Annotation>, Context> getContexts() {
        return this.contexts;
    }

    protected List<String> getNamespaces() {
        return this.namespaces;
    }

    public Iterable<String> getAccessibleNamespaces() {
        return this.createDynamicAccessibleIterable(Transform.NAMESPACE);
    }

    protected AtomicInteger getIds() {
        return this.ids;
    }

    private Set<CurrentActivity> getCurrentActivities() {
        return this.currentActivities;
    }

    public Integer getId() {
        return this.id;
    }

    public List<ObserverMethod<?, ?>> getObservers() {
        return this.observers;
    }

    public Namespace getRootNamespace() {
        if (this.rootNamespace == null) {
            this.rootNamespace = new Namespace(this.createDynamicAccessibleIterable(Transform.NAMESPACE));
        }
        return this.rootNamespace;
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        return new SimpleInjectionTarget<T>(this.getServices().get(ClassTransformer.class).loadClass(type), this);
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(EjbDescriptor<T> descriptor) {
        return this.getBean((EjbDescriptor)descriptor);
    }

    @Override
    public <X> Bean<? extends X> getMostSpecializedBean(Bean<X> bean) {
        Contextual<Object> key = bean;
        while (this.specializedBeans.containsKey(key)) {
            if (key == null) {
                System.out.println("null key " + bean);
            }
            key = this.specializedBeans.get(key);
        }
        return key;
    }

    @Override
    public void validate(InjectionPoint ij) {
        try {
            this.getServices().get(Validator.class).validateInjectionPoint(ij, this);
        }
        catch (DeploymentException e) {
            throw new InjectionException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Set<Annotation> getInterceptorBindingTypeDefinition(Class<? extends Annotation> bindingType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        if (this.getServices().get(MetaAnnotationStore.class).getStereotype(stereotype).isValid()) {
            return this.getServices().get(MetaAnnotationStore.class).getStereotype(stereotype).getMetaAnnotations();
        }
        throw new IllegalArgumentException("Not a stereotype " + stereotype);
    }

    @Override
    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotationType).isValid();
    }

    @Override
    public boolean isInterceptorBindingType(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        ScopeModel<? extends Annotation> scope = this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType);
        return scope.isValid() && scope.isNormal();
    }

    @Override
    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        ScopeModel<? extends Annotation> scope = this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType);
        return scope.isValid() && scope.isPassivating();
    }

    @Override
    public boolean isScope(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType).isValid();
    }

    @Override
    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getStereotype(annotationType).isValid();
    }

    @Override
    public ELResolver getELResolver() {
        return this.webbeansELResolver;
    }

    public <T> WBCreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        return new CreationalContextImpl<T>(contextual);
    }

    @Override
    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        return this.getServices().get(ClassTransformer.class).loadClass(type);
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        Set<Bean<X>> resolvedBeans = this.beanResolver.resolve(beans);
        if (resolvedBeans.size() == 0) {
            return null;
        }
        if (resolvedBeans.size() == 1) {
            return resolvedBeans.iterator().next();
        }
        throw new AmbiguousResolutionException("Cannot resolve an ambiguous dependency between " + beans);
    }

    @Override
    public <T> EjbDescriptor<T> getEjbDescriptor(String beanName) {
        return this.getServices().get(EjbDescriptors.class).get(beanName);
    }

    public <T> EnterpriseBean<T> getBean(EjbDescriptor<T> descriptor) {
        return this.getEnterpriseBeans().get(descriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Transform<T> {
        public static final Transform<Bean<?>> BEAN = new Transform<Bean<?>>(){

            @Override
            public Iterable<Bean<?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getBeans();
            }
        };
        public static final Transform<DecoratorBean<?>> DECORATOR_BEAN = new Transform<DecoratorBean<?>>(){

            @Override
            public Iterable<DecoratorBean<?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getDecorators();
            }
        };
        public static final Transform<ObserverMethod<?, ?>> EVENT_OBSERVER = new Transform<ObserverMethod<?, ?>>(){

            @Override
            public Iterable<ObserverMethod<?, ?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getObservers();
            }
        };
        public static final Transform<String> NAMESPACE = new Transform<String>(){

            @Override
            public Iterable<String> transform(BeanManagerImpl beanManager) {
                return beanManager.getNamespaces();
            }
        };

        public Iterable<T> transform(BeanManagerImpl var1);
    }

    private static class CurrentActivity {
        private final Context context;
        private final BeanManagerImpl manager;

        public CurrentActivity(Context context, BeanManagerImpl manager) {
            this.context = context;
            this.manager = manager;
        }

        public Context getContext() {
            return this.context;
        }

        public BeanManagerImpl getManager() {
            return this.manager;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CurrentActivity) {
                return this.getContext().equals(((CurrentActivity)obj).getContext());
            }
            return false;
        }

        public int hashCode() {
            return this.getContext().hashCode();
        }

        public String toString() {
            return this.getContext() + " -> " + this.getManager();
        }
    }
}

