/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.injection.ConstructorInjectionPoint;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.InjectionContextImpl;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.util.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInjectionTarget<T>
implements InjectionTarget<T> {
    private final BeanManagerImpl beanManager;
    private final WBClass<T> type;
    private final ConstructorInjectionPoint<T> constructor;
    private final Set<FieldInjectionPoint<?, ?>> injectableFields;
    private final Set<MethodInjectionPoint<?, ?>> initializerMethods;
    private final WBMethod<?, ?> postConstruct;
    private final WBMethod<?, ?> preDestroy;
    private final Set<InjectionPoint> injectionPoints;
    private final Set<WBInjectionPoint<?, ?>> ejbInjectionPoints;
    private final Set<WBInjectionPoint<?, ?>> persistenceContextInjectionPoints;
    private final Set<WBInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private final Set<WBInjectionPoint<?, ?>> resourceInjectionPoints;

    public SimpleInjectionTarget(WBClass<T> type, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.type = type;
        this.injectionPoints = new HashSet<InjectionPoint>();
        this.constructor = Beans.getBeanConstructor(null, type);
        this.injectionPoints.addAll(Beans.getParameterInjectionPoints(null, this.constructor));
        this.injectableFields = new HashSet();
        this.injectableFields.addAll(Beans.getFieldInjectionPoints(null, type));
        this.injectionPoints.addAll(this.injectableFields);
        this.initializerMethods = new HashSet();
        this.initializerMethods.addAll(Beans.getInitializerMethods(null, type));
        this.injectionPoints.addAll(Beans.getParameterInjectionPoints(null, this.initializerMethods));
        this.postConstruct = Beans.getPostConstruct(type);
        this.preDestroy = Beans.getPreDestroy(type);
        this.ejbInjectionPoints = Beans.getEjbInjectionPoints(null, type, beanManager);
        this.persistenceContextInjectionPoints = Beans.getPersistenceContextInjectionPoints(null, type, beanManager);
        this.persistenceUnitInjectionPoints = Beans.getPersistenceUnitInjectionPoints(null, type, beanManager);
        this.resourceInjectionPoints = Beans.getResourceInjectionPoints(null, type, beanManager);
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        return this.constructor.newInstance(this.beanManager, ctx);
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx) {
        new InjectionContextImpl<T>(this.beanManager, this, instance){

            @Override
            public void proceed() {
                Beans.injectEEFields(instance, SimpleInjectionTarget.this.beanManager, SimpleInjectionTarget.this.ejbInjectionPoints, SimpleInjectionTarget.this.persistenceContextInjectionPoints, SimpleInjectionTarget.this.persistenceUnitInjectionPoints, SimpleInjectionTarget.this.resourceInjectionPoints);
                Beans.injectBoundFields(instance, ctx, SimpleInjectionTarget.this.beanManager, SimpleInjectionTarget.this.injectableFields);
                Beans.callInitializers(instance, ctx, SimpleInjectionTarget.this.beanManager, SimpleInjectionTarget.this.initializerMethods);
            }
        }.run();
    }

    @Override
    public void postConstruct(T instance) {
        if (this.postConstruct == null) {
            return;
        }
        try {
            this.postConstruct.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking postConstruct() " + this.postConstruct, e);
        }
    }

    @Override
    public void preDestroy(T instance) {
        if (this.preDestroy == null) {
            return;
        }
        try {
            this.preDestroy.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking preDestroy() " + this.preDestroy, e);
        }
    }

    @Override
    public void dispose(T instance) {
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }
}

