/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.util.Map;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.AbstractContainerEvent;
import org.jboss.webbeans.bootstrap.BeanDeployment;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.webbeans.bootstrap.spi.Deployment;
import org.jboss.webbeans.metadata.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanDiscoveryEvent
extends AbstractContainerEvent {
    private final Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;
    private final BeanManagerImpl deploymentManager;
    private final Deployment deployment;

    public AbstractBeanDiscoveryEvent(Map<BeanDeploymentArchive, BeanDeployment> beanDeployments, BeanManagerImpl deploymentManager, Deployment deployment) {
        this.beanDeployments = beanDeployments;
        this.deploymentManager = deploymentManager;
        this.deployment = deployment;
    }

    protected Map<BeanDeploymentArchive, BeanDeployment> getBeanDeployments() {
        return this.beanDeployments;
    }

    protected Deployment getDeployment() {
        return this.deployment;
    }

    protected BeanManagerImpl getDeploymentManager() {
        return this.deploymentManager;
    }

    protected TypeStore getTypeStore() {
        return this.getDeployment().getServices().get(TypeStore.class);
    }

    protected BeanDeployment getOrCreateBeanDeployment(Class<?> clazz) {
        BeanDeploymentArchive beanDeploymentArchive = this.getDeployment().loadBeanDeploymentArchive(clazz);
        if (beanDeploymentArchive == null) {
            throw new IllegalStateException("Unable to find Bean Deployment Archive for " + clazz);
        }
        if (this.getBeanDeployments().containsKey(beanDeploymentArchive)) {
            return this.getBeanDeployments().get(beanDeploymentArchive);
        }
        BeanDeployment beanDeployment = new BeanDeployment(beanDeploymentArchive, this.getDeploymentManager());
        this.getBeanDeployments().put(beanDeploymentArchive, beanDeployment);
        return beanDeployment;
    }
}

