/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.interceptor.Interceptor;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.AbstractBeanDeployer;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.bootstrap.ProcessAnnotatedTypeImpl;
import org.jboss.webbeans.ejb.EjbDescriptors;
import org.jboss.webbeans.ejb.InternalEjbDescriptor;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployer
extends AbstractBeanDeployer {
    private final BeanManagerImpl deploymentManager;
    private final Set<WBClass<?>> classes = new HashSet();

    public BeanDeployer(BeanManagerImpl manager, BeanManagerImpl deploymentManager, EjbDescriptors ejbDescriptors) {
        super(manager, new BeanDeployerEnvironment(ejbDescriptors, manager));
        this.deploymentManager = deploymentManager;
    }

    public AbstractBeanDeployer addClass(Class<?> clazz) {
        ClassTransformer classTransformer = this.getManager().getServices().get(ClassTransformer.class);
        if (!clazz.isAnnotation() && !clazz.isEnum()) {
            ProcessAnnotatedTypeImpl<?> event = this.createProcessAnnotatedTypeEvent(clazz, classTransformer);
            this.deploymentManager.fireEvent(event, new Annotation[0]);
            if (!event.isVeto()) {
                if (event.getAnnotatedType() instanceof WBClass) {
                    this.classes.add((WBClass)event.getAnnotatedType());
                } else {
                    this.classes.add(classTransformer.loadClass(event.getAnnotatedType()));
                }
            }
        }
        return this;
    }

    private <X> ProcessAnnotatedTypeImpl<X> createProcessAnnotatedTypeEvent(Class<X> clazz, ClassTransformer classTransformer) {
        WBClass<X> annotatedType = classTransformer.loadClass(clazz);
        return new ProcessAnnotatedTypeImpl<X>(annotatedType){};
    }

    public AbstractBeanDeployer addClass(AnnotatedType<?> clazz) {
        ClassTransformer classTransformer = this.getManager().getServices().get(ClassTransformer.class);
        this.classes.add(classTransformer.loadClass(clazz));
        return this;
    }

    public AbstractBeanDeployer addClasses(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.addClass(clazz);
        }
        return this;
    }

    public AbstractBeanDeployer createBeans() {
        for (WBClass<?> clazz : this.classes) {
            boolean managedBeanOrDecorator;
            boolean bl = managedBeanOrDecorator = !this.getEnvironment().getEjbDescriptors().contains(clazz.getJavaClass()) && this.isTypeManagedBeanOrDecorator(clazz);
            if (managedBeanOrDecorator && clazz.isAnnotationPresent(Decorator.class)) {
                this.createDecorator(clazz);
                continue;
            }
            if (managedBeanOrDecorator && clazz.isAnnotationPresent(Interceptor.class) || !managedBeanOrDecorator || clazz.isAbstract()) continue;
            this.createSimpleBean(clazz);
        }
        for (InternalEjbDescriptor ejbDescriptor : this.getEnvironment().getEjbDescriptors()) {
            this.createEnterpriseBean(ejbDescriptor);
        }
        return this;
    }
}

