/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bootstrap.api.Lifecycle;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.conversation.ConversationManager;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

public class ContextLifecycle
implements Lifecycle {
    private static LogProvider log = Logging.getLogProvider(ContextLifecycle.class);

    public void restoreSession(String id, BeanStore sessionBeanStore) {
        log.trace("Restoring session " + id);
        SessionContext sessionContext = CurrentManager.rootManager().getServices().get(SessionContext.class);
        sessionContext.setBeanStore(sessionBeanStore);
        sessionContext.setActive(true);
    }

    public void endSession(String id, BeanStore sessionBeanStore, ConversationManager conversationManager) {
        log.trace("Ending session " + id);
        SessionContext sessionContext = CurrentManager.rootManager().getServices().get(SessionContext.class);
        sessionContext.setActive(true);
        conversationManager.destroyAllConversations();
        sessionContext.destroy();
        sessionContext.setBeanStore(null);
        sessionContext.setActive(false);
    }

    public void beginRequest(String id, BeanStore requestBeanStore) {
        log.trace("Starting request " + id);
        RequestContext requestContext = CurrentManager.rootManager().getServices().get(RequestContext.class);
        DependentContext dependentContext = CurrentManager.rootManager().getServices().get(DependentContext.class);
        requestContext.setBeanStore(requestBeanStore);
        requestContext.setActive(true);
        dependentContext.setActive(true);
    }

    public void endRequest(String id, BeanStore requestBeanStore) {
        log.trace("Ending request " + id);
        RequestContext requestContext = CurrentManager.rootManager().getServices().get(RequestContext.class);
        DependentContext dependentContext = CurrentManager.rootManager().getServices().get(DependentContext.class);
        requestContext.setBeanStore(requestBeanStore);
        dependentContext.setActive(false);
        requestContext.destroy();
        requestContext.setActive(false);
    }
}

