/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.ConstructorSignature;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBConstructor;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.introspector.jlr.AbstractWBCallable;
import org.jboss.webbeans.introspector.jlr.ConstructorSignatureImpl;
import org.jboss.webbeans.introspector.jlr.WBParameterImpl;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBConstructorImpl<T>
extends AbstractWBCallable<T, T, Constructor<T>>
implements WBConstructor<T> {
    private final Constructor<T> constructor;
    private final List<WBParameter<?, ?>> parameters;
    private final ListMultimap<Class<? extends Annotation>, WBParameter<?, ?>> annotatedParameters;
    private final ConstructorSignature signature;
    private String toString;

    public static <T> WBConstructor<T> of(Constructor<T> constructor, WBClass<T> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(constructor, classTransformer.getTypeStore());
        return new WBConstructorImpl<T>(Reflections.ensureAccessible(constructor), null, annotationStore, declaringClass, classTransformer);
    }

    public static <T> WBConstructor<T> of(AnnotatedConstructor<T> annotatedConstructor, WBClass<T> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(annotatedConstructor.getAnnotations(), annotatedConstructor.getAnnotations(), classTransformer.getTypeStore());
        return new WBConstructorImpl<T>(Reflections.ensureAccessible(annotatedConstructor.getJavaMember()), annotatedConstructor, annotationStore, declaringClass, classTransformer);
    }

    private WBConstructorImpl(Constructor<T> constructor, AnnotatedConstructor<T> annotatedConstructor, AnnotationStore annotationStore, WBClass<T> declaringClass, ClassTransformer classTransformer) {
        super(annotationStore, constructor, constructor.getDeclaringClass(), constructor.getDeclaringClass(), declaringClass);
        this.constructor = constructor;
        this.parameters = new ArrayList();
        this.annotatedParameters = Multimaps.newListMultimap(new HashMap(), new Supplier<List<WBParameter<?, ?>>>(){

            @Override
            public List<WBParameter<?, ?>> get() {
                return new ArrayList();
            }
        });
        HashMap annotatedTypeParameters = new HashMap();
        if (annotatedConstructor != null) {
            for (AnnotatedParameter annotated : annotatedConstructor.getParameters()) {
                annotatedTypeParameters.put(annotated.getPosition(), annotated);
            }
        }
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            WBParameter parameter;
            Type type;
            Class<?> clazz;
            if (constructor.getParameterAnnotations()[i].length > 0) {
                clazz = constructor.getParameterTypes()[i];
                type = constructor.getGenericParameterTypes()[i];
                parameter = null;
                if (annotatedTypeParameters.containsKey(i)) {
                    AnnotatedParameter annotatedParameter = (AnnotatedParameter)annotatedTypeParameters.get(i);
                    parameter = WBParameterImpl.of(annotatedParameter.getAnnotations(), clazz, type, this, i, classTransformer);
                } else {
                    parameter = WBParameterImpl.of(constructor.getParameterAnnotations()[i], clazz, type, this, i, classTransformer);
                }
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotations()) {
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = constructor.getParameterTypes()[i];
            type = constructor.getGenericParameterTypes().length > i ? constructor.getGenericParameterTypes()[i] : clazz;
            parameter = WBParameterImpl.of(new Annotation[0], clazz, type, this, i, classTransformer);
            this.parameters.add(parameter);
            for (Annotation annotation : parameter.getAnnotations()) {
                this.annotatedParameters.put(annotation.annotationType(), parameter);
            }
        }
        this.signature = new ConstructorSignatureImpl(this);
    }

    public Constructor<T> getAnnotatedConstructor() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getDelegate() {
        return this.constructor;
    }

    @Override
    public List<WBParameter<?, ?>> getWBParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<WBParameter<?, ?>> getAnnotatedWBParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList(this.annotatedParameters.get(annotationType));
    }

    @Override
    public T newInstance(Object ... parameters) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ((Constructor)this.getDelegate()).newInstance(parameters);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof WBConstructor) {
            WBConstructor that = (WBConstructor)other;
            return this.getDeclaringType().equals(that.getDeclaringType()) && ((Object)this.getWBParameters()).equals(that.getWBParameters());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Constructor)this.getDelegate()).hashCode();
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated constructor " + Names.constructorToString(this.constructor);
        return this.toString;
    }

    @Override
    public ConstructorSignature getSignature() {
        return this.signature;
    }

    @Override
    public List<AnnotatedParameter<T>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }
}

