/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.jsf;

import java.lang.annotation.Annotation;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.conversation.ConversationManager;
import org.jboss.webbeans.jsf.JsfHelper;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ConversationBeanStore;
import org.jboss.webbeans.servlet.HttpSessionManager;

public class WebBeansPhaseListener
implements PhaseListener {
    private static LogProvider log = Logging.getLogProvider(WebBeansPhaseListener.class);

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.beforeRestoreView(phaseEvent.getFacesContext());
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.afterRenderResponse(phaseEvent.getFacesContext());
        } else if (phaseEvent.getFacesContext().getResponseComplete()) {
            this.afterResponseComplete(phaseEvent.getFacesContext(), phaseEvent.getPhaseId());
        }
    }

    private void beforeRestoreView(FacesContext facesContext) {
        log.trace("Initiating the session and conversation before the Restore View phase");
        this.initiateSessionAndConversation(facesContext);
    }

    private void afterRenderResponse(FacesContext facesContext) {
        BeanManagerImpl moduleBeanManager = JsfHelper.getModuleBeanManager(facesContext);
        SessionContext sessionContext = moduleBeanManager.getServices().get(SessionContext.class);
        ConversationContext conversationContext = moduleBeanManager.getServices().get(ConversationContext.class);
        if (sessionContext.isActive()) {
            log.trace("Cleaning up the conversation after the Render Response phase");
            moduleBeanManager.getInstanceByType(ConversationManager.class, new Annotation[0]).cleanupConversation();
            conversationContext.setActive(false);
        } else {
            log.trace("Skipping conversation cleanup after the Render Response phase because session has been terminated.");
        }
    }

    private void afterResponseComplete(FacesContext facesContext, PhaseId phaseId) {
        BeanManagerImpl moduleBeanManager = JsfHelper.getModuleBeanManager(facesContext);
        SessionContext sessionContext = moduleBeanManager.getServices().get(SessionContext.class);
        if (sessionContext.isActive()) {
            log.trace("Cleaning up the conversation after the " + phaseId + " phase as the response has been marked complete");
            moduleBeanManager.getInstanceByType(ConversationManager.class, new Annotation[0]).cleanupConversation();
        } else {
            log.trace("Skipping conversation cleanup after the response has been marked complete because the session has been terminated.");
        }
    }

    private void initiateSessionAndConversation(FacesContext facesContext) {
        HttpSession session = JsfHelper.getHttpSession(facesContext);
        BeanManagerImpl moduleBeanManager = JsfHelper.getModuleBeanManager(facesContext);
        moduleBeanManager.getInstanceByType(HttpSessionManager.class, new Annotation[0]).setSession(session);
        moduleBeanManager.getInstanceByType(ConversationManager.class, new Annotation[0]).beginOrRestoreConversation(JsfHelper.getConversationId(facesContext));
        String cid = moduleBeanManager.getInstanceByType(ConversationImpl.class, new Annotation[0]).getUnderlyingId();
        ConversationContext conversationContext = moduleBeanManager.getServices().get(ConversationContext.class);
        conversationContext.setBeanStore(new ConversationBeanStore(session, cid));
        conversationContext.setActive(true);
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

