/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans.ejb;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.ejb.api.EjbContainerServices;
import org.glassfish.webbeans.InjectionPointHelper;
import org.glassfish.webbeans.ejb.EjbDescriptorImpl;
import org.glassfish.webbeans.ejb.SessionObjectReferenceImpl;
import org.jboss.webbeans.ejb.api.SessionObjectReference;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServicesImpl
implements EjbServices {
    private Set<com.sun.enterprise.deployment.EjbDescriptor> ejbDescs;
    private Habitat habitat;
    private InjectionPointHelper injectionPointHelper;

    public EjbServicesImpl(Habitat h, Set<com.sun.enterprise.deployment.EjbDescriptor> ejbs) {
        this.habitat = h;
        this.ejbDescs = ejbs;
        this.injectionPointHelper = new InjectionPointHelper(h);
    }

    public Object resolveEjb(InjectionPoint injectionPoint) {
        EjbContainerServices containerServices = (EjbContainerServices)this.habitat.getByContract(EjbContainerServices.class);
        Annotation ejbAnnotation = null;
        for (Annotation annotation : injectionPoint.getAnnotated().getAnnotations()) {
            if (!annotation.annotationType().getName().equals("javax.ejb.EJB")) continue;
            ejbAnnotation = annotation;
            break;
        }
        if (ejbAnnotation == null) {
            throw new IllegalArgumentException("injection point is not annotated with @EJB " + injectionPoint);
        }
        Object resolvedEjb = null;
        try {
            Application app = this.ejbDescs.iterator().next().getApplication();
            resolvedEjb = this.injectionPointHelper.resolveInjectionPoint(injectionPoint.getMember(), app);
        }
        catch (NamingException ne) {
            throw new IllegalArgumentException("Unable to resolve injection point " + injectionPoint, ne);
        }
        return resolvedEjb;
    }

    @Override
    public SessionObjectReference resolveEjb(EjbDescriptor<?> ejbDescriptor) {
        SessionObjectReferenceImpl sessionObj = null;
        String globalJndiName = this.getDefaultGlobalJndiName(ejbDescriptor);
        if (globalJndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                Object ejbRef = ic.lookup(globalJndiName);
                EjbContainerServices containerServices = (EjbContainerServices)this.habitat.getByContract(EjbContainerServices.class);
                sessionObj = new SessionObjectReferenceImpl(containerServices, ejbRef);
            }
            catch (NamingException ne) {
                throw new IllegalStateException("Error resolving session object reference for ejb name " + ejbDescriptor.getBeanClass() + " and jndi name " + globalJndiName, ne);
            }
        } else {
            throw new IllegalArgumentException("Not enough type information to resolve ejb for  ejb name " + ejbDescriptor.getBeanClass());
        }
        return sessionObj;
    }

    public Object resolveRemoteEjb(String jndiName, String mappedName, String ejbLink) {
        Object remoteRef = null;
        if (jndiName == null && mappedName == null && ejbLink == null) {
            throw new IllegalArgumentException("All linking arguments are null");
        }
        String lookupString = jndiName;
        try {
            InitialContext ic = new InitialContext();
            if (lookupString == null) {
                lookupString = mappedName != null ? mappedName : "java:module/" + ejbLink;
            }
            remoteRef = ic.lookup(lookupString);
        }
        catch (NamingException ne) {
            throw new IllegalStateException("Error resolving session object reference for name " + lookupString, ne);
        }
        return remoteRef;
    }

    private String getDefaultGlobalJndiName(EjbDescriptor ejbDesc) {
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)((EjbDescriptorImpl)ejbDesc).getEjbDescriptor();
        String clientView = null;
        if (sessionDesc.isLocalBean()) {
            clientView = sessionDesc.getEjbClassName();
        } else if (sessionDesc.getLocalBusinessClassNames().size() == 1) {
            clientView = (String)sessionDesc.getLocalBusinessClassNames().iterator().next();
        } else if (sessionDesc.getRemoteBusinessClassNames().size() == 1) {
            clientView = (String)sessionDesc.getRemoteBusinessClassNames().iterator().next();
        }
        return clientView != null ? sessionDesc.getPortableJndiName(clientView) : null;
    }
}

