/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.spi.Contextual;
import org.jboss.webbeans.bootstrap.api.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextualIdStore
implements Service {
    private final BiMap<Contextual<?>, Integer> contextuals;
    private final AtomicInteger idGenerator = new AtomicInteger(0);

    public ContextualIdStore() {
        HashBiMap map = HashBiMap.create();
        this.contextuals = Maps.synchronizedBiMap(map);
    }

    public <T> Contextual<T> getContextual(Integer id) {
        return (Contextual)this.contextuals.inverse().get(id);
    }

    public Integer getId(Contextual<?> contextual) {
        if (this.contextuals.containsKey(contextual)) {
            return (Integer)this.contextuals.get(contextual);
        }
        Integer id = this.idGenerator.incrementAndGet();
        this.contextuals.put(contextual, id);
        return id;
    }
}

