/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.ContextualIdStore;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.DeploymentException;
import org.jboss.webbeans.Validator;
import org.jboss.webbeans.bean.builtin.ManagerBean;
import org.jboss.webbeans.bootstrap.AfterBeanDiscoveryImpl;
import org.jboss.webbeans.bootstrap.AfterDeploymentValidationImpl;
import org.jboss.webbeans.bootstrap.BeanDeployment;
import org.jboss.webbeans.bootstrap.BeforeBeanDiscoveryImpl;
import org.jboss.webbeans.bootstrap.BeforeShutdownImpl;
import org.jboss.webbeans.bootstrap.ExtensionBeanDeployer;
import org.jboss.webbeans.bootstrap.api.Bootstrap;
import org.jboss.webbeans.bootstrap.api.Environment;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.webbeans.bootstrap.spi.Deployment;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.ContextLifecycle;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.jsf.JsfApiAbstraction;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.TypeStore;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.persistence.PersistenceApiAbstraction;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.resources.DefaultResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.servlet.ServletApiAbstraction;
import org.jboss.webbeans.transaction.spi.TransactionServices;
import org.jboss.webbeans.util.serviceProvider.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansBootstrap
implements Bootstrap {
    private static Log log = Logging.getLog(WebBeansBootstrap.class);
    private BeanManagerImpl deploymentManager;
    private Map<BeanDeploymentArchive, BeanDeployment> beanDeployments;
    private Environment environment;
    private Deployment deployment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap startContainer(Environment environment, Deployment deployment, BeanStore applicationBeanStore) {
        WebBeansBootstrap webBeansBootstrap = this;
        synchronized (webBeansBootstrap) {
            if (deployment == null) {
                throw new IllegalArgumentException("Must start the container with a deployment");
            }
            if (!deployment.getServices().contains(ResourceLoader.class)) {
                deployment.getServices().add(ResourceLoader.class, new DefaultResourceLoader());
            }
            WebBeansBootstrap.verifyServices(deployment.getServices(), environment.getRequiredDeploymentServices());
            if (!deployment.getServices().contains(TransactionServices.class)) {
                log.info((Object)"Transactional services not available. Injection of @Current UserTransaction not available. Transactional observers will be invoked synchronously.", new Object[0]);
            }
            if (applicationBeanStore == null) {
                throw new IllegalStateException("No application context BeanStore set");
            }
            this.deployment = deployment;
            this.addImplementationServices(deployment.getServices());
            this.environment = environment;
            this.deploymentManager = BeanManagerImpl.newRootManager(ServiceRegistries.unmodifiableServiceRegistry(deployment.getServices()));
            CurrentManager.setRootManager(this.deploymentManager);
            this.createContexts();
            this.initializeContexts();
            this.beginApplication(applicationBeanStore);
            DeploymentVisitor deploymentVisitor = new DeploymentVisitor(this.deploymentManager, environment, deployment);
            this.beanDeployments = deploymentVisitor.visit();
            return this;
        }
    }

    private void addImplementationServices(ServiceRegistry services) {
        ResourceLoader resourceLoader = services.get(ResourceLoader.class);
        services.add(EJBApiAbstraction.class, new EJBApiAbstraction(resourceLoader));
        services.add(JsfApiAbstraction.class, new JsfApiAbstraction(resourceLoader));
        services.add(PersistenceApiAbstraction.class, new PersistenceApiAbstraction(resourceLoader));
        services.add(ServletApiAbstraction.class, new ServletApiAbstraction(resourceLoader));
        services.add(Validator.class, new Validator());
        services.add(TypeStore.class, new TypeStore());
        services.add(ClassTransformer.class, new ClassTransformer(services.get(TypeStore.class)));
        services.add(MetaAnnotationStore.class, new MetaAnnotationStore(services.get(ClassTransformer.class)));
        services.add(ContextualIdStore.class, new ContextualIdStore());
    }

    @Override
    public BeanManagerImpl getManager(BeanDeploymentArchive beanDeploymentArchive) {
        if (this.beanDeployments.containsKey(beanDeploymentArchive)) {
            return this.beanDeployments.get(beanDeploymentArchive).getBeanManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap startInitialization() {
        WebBeansBootstrap webBeansBootstrap = this;
        synchronized (webBeansBootstrap) {
            if (this.deploymentManager == null) {
                throw new IllegalStateException("Manager has not been initialized");
            }
            ExtensionBeanDeployer extensionBeanDeployer = new ExtensionBeanDeployer(this.deploymentManager);
            extensionBeanDeployer.addExtensions(ServiceLoader.load(Extension.class));
            extensionBeanDeployer.createBeans().deploy();
            this.deploymentManager.addBean(new ManagerBean(this.deploymentManager));
            this.fireBeforeBeanDiscoveryEvent();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap deployBeans() {
        WebBeansBootstrap webBeansBootstrap = this;
        synchronized (webBeansBootstrap) {
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                entry.getValue().deployBeans(this.environment);
            }
            this.fireAfterBeanDiscoveryEvent();
            log.debug((Object)"Web Beans initialized. Validating beans.", new Object[0]);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap validateBeans() {
        WebBeansBootstrap webBeansBootstrap = this;
        synchronized (webBeansBootstrap) {
            for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : this.beanDeployments.entrySet()) {
                this.deploymentManager.getServices().get(Validator.class).validateDeployment(entry.getValue().getBeanManager(), entry.getValue().getBeanDeployer().getEnvironment());
            }
            this.fireAfterDeploymentValidationEvent();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bootstrap endInitialization() {
        WebBeansBootstrap webBeansBootstrap = this;
        synchronized (webBeansBootstrap) {
            CurrentManager.setBeanDeploymentArchives(this.beanDeployments);
        }
        return this;
    }

    private void fireBeforeBeanDiscoveryEvent() {
        BeforeBeanDiscoveryImpl event = new BeforeBeanDiscoveryImpl(this.deploymentManager, this.deployment, this.beanDeployments);
        try {
            this.deploymentManager.fireEvent(event, new Annotation[0]);
        }
        catch (Exception e) {
            throw new DefinitionException(e);
        }
    }

    private void fireBeforeShutdownEvent() {
        BeforeShutdownImpl event = new BeforeShutdownImpl();
        try {
            this.deploymentManager.fireEvent(event, new Annotation[0]);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    private void fireAfterBeanDiscoveryEvent() {
        AfterBeanDiscoveryImpl event = new AfterBeanDiscoveryImpl(this.deploymentManager, this.deployment, this.beanDeployments);
        try {
            this.deploymentManager.fireEvent(event, new Annotation[0]);
        }
        catch (Exception e) {
            event.addDefinitionError(e);
        }
        if (event.getDefinitionErrors().size() > 0) {
            throw new DefinitionException(event.getDefinitionErrors().get(0));
        }
    }

    private void fireAfterDeploymentValidationEvent() {
        AfterDeploymentValidationImpl event = new AfterDeploymentValidationImpl();
        try {
            this.deploymentManager.fireEvent(event, new Annotation[0]);
        }
        catch (Exception e) {
            event.addDeploymentProblem(e);
        }
        if (event.getDeploymentProblems().size() > 0) {
            throw new DeploymentException(event.getDeploymentProblems().get(0));
        }
    }

    public static String getVersion() {
        Package pkg = WebBeansBootstrap.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    protected void initializeContexts() {
        this.deploymentManager.addContext(this.deploymentManager.getServices().get(DependentContext.class));
        this.deploymentManager.addContext(this.deploymentManager.getServices().get(RequestContext.class));
        this.deploymentManager.addContext(this.deploymentManager.getServices().get(ConversationContext.class));
        this.deploymentManager.addContext(this.deploymentManager.getServices().get(SessionContext.class));
        this.deploymentManager.addContext(this.deploymentManager.getServices().get(ApplicationContext.class));
    }

    protected void createContexts() {
        this.deployment.getServices().add(ContextLifecycle.class, new ContextLifecycle());
        this.deployment.getServices().add(DependentContext.class, new DependentContext());
        this.deployment.getServices().add(RequestContext.class, new RequestContext());
        this.deployment.getServices().add(ConversationContext.class, new ConversationContext());
        this.deployment.getServices().add(SessionContext.class, new SessionContext());
        this.deployment.getServices().add(ApplicationContext.class, new ApplicationContext());
    }

    protected void beginApplication(BeanStore applicationBeanStore) {
        log.trace((Object)"Starting application", new Object[0]);
        ApplicationContext applicationContext = this.deploymentManager.getServices().get(ApplicationContext.class);
        applicationContext.setBeanStore(applicationBeanStore);
        applicationContext.setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            this.fireBeforeShutdownEvent();
        }
        finally {
            this.deploymentManager.shutdown();
        }
    }

    protected static void verifyServices(ServiceRegistry services, Set<Class<? extends Service>> requiredServices) {
        for (Class<? extends Service> serviceType : requiredServices) {
            if (services.contains(serviceType)) continue;
            throw new IllegalStateException("Required service " + serviceType.getName() + " has not been specified");
        }
    }

    static {
        log.info((Object)("Web Beans " + WebBeansBootstrap.getVersion()), new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeploymentVisitor {
        private final BeanManagerImpl deploymentManager;
        private final Environment environment;
        private final Deployment deployment;

        public DeploymentVisitor(BeanManagerImpl deploymentManager, Environment environment, Deployment deployment) {
            this.deploymentManager = deploymentManager;
            this.environment = environment;
            this.deployment = deployment;
        }

        public Map<BeanDeploymentArchive, BeanDeployment> visit() {
            HashSet<BeanDeploymentArchive> seenBeanDeploymentArchives = new HashSet<BeanDeploymentArchive>();
            HashMap<BeanDeploymentArchive, BeanDeployment> managerAwareBeanDeploymentArchives = new HashMap<BeanDeploymentArchive, BeanDeployment>();
            for (BeanDeploymentArchive archvive : this.deployment.getBeanDeploymentArchives()) {
                this.visit(archvive, managerAwareBeanDeploymentArchives, seenBeanDeploymentArchives);
            }
            return managerAwareBeanDeploymentArchives;
        }

        private BeanDeployment visit(BeanDeploymentArchive beanDeploymentArchive, Map<BeanDeploymentArchive, BeanDeployment> managerAwareBeanDeploymentArchives, Set<BeanDeploymentArchive> seenBeanDeploymentArchives) {
            WebBeansBootstrap.verifyServices(beanDeploymentArchive.getServices(), this.environment.getRequiredBeanDeploymentArchiveServices());
            BeanDeployment parent = new BeanDeployment(beanDeploymentArchive, this.deploymentManager);
            managerAwareBeanDeploymentArchives.put(beanDeploymentArchive, parent);
            seenBeanDeploymentArchives.add(beanDeploymentArchive);
            for (BeanDeploymentArchive archive : beanDeploymentArchive.getBeanDeploymentArchives()) {
                if (seenBeanDeploymentArchives.contains(archive)) continue;
                BeanDeployment child = this.visit(archive, managerAwareBeanDeploymentArchives, seenBeanDeploymentArchives);
                parent.getBeanManager().addAccessibleBeanManager(child.getBeanManager());
            }
            return parent;
        }
    }
}

