/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.lang.annotation.Annotation;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.webbeans.context.AbstractContext;
import org.jboss.webbeans.context.BeanInstanceImpl;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.api.ContexutalInstance;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapContext
extends AbstractContext {
    private static LogProvider log = Logging.getLogProvider(AbstractMapContext.class);
    private static ReentrantLock creationLock = new ReentrantLock();

    public AbstractMapContext(Class<? extends Annotation> scopeType) {
        super(scopeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        ContexutalInstance<T> beanInstance = this.getBeanStore().get(contextual);
        if (beanInstance != null) {
            return beanInstance.getInstance();
        }
        if (creationalContext != null) {
            boolean needCreationLock = this.isCreationLockRequired();
            try {
                T instance;
                if (needCreationLock) {
                    creationLock.lock();
                    beanInstance = this.getBeanStore().get(contextual);
                    if (beanInstance != null) {
                        T t = beanInstance.getInstance();
                        return t;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    beanInstance = new BeanInstanceImpl<T>(contextual, instance, creationalContext);
                    this.getBeanStore().put(beanInstance);
                }
                T t = instance;
                return t;
            }
            finally {
                if (needCreationLock) {
                    creationLock.unlock();
                }
            }
        }
        return null;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    private <T> void destroy(Contextual<T> contextual) {
        log.trace("Destroying " + contextual);
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        ContexutalInstance<T> beanInstance = this.getBeanStore().get(contextual);
        contextual.destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
    }

    public void destroy() {
        log.trace("Destroying context");
        if (this.getBeanStore() == null) {
            throw new IllegalStateException("No bean store available for " + this.toString());
        }
        for (Contextual<?> bean : this.getBeanStore().getContextuals()) {
            this.destroy(bean);
        }
        this.getBeanStore().clear();
    }

    protected abstract BeanStore getBeanStore();

    protected abstract boolean isCreationLockRequired();
}

