/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata.cache;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.metadata.cache.StereotypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedStereotypes<T, E> {
    private final Set<Annotation> possibleScopeTypes = new HashSet<Annotation>();
    private boolean beanNameDefaulted;
    private boolean policy;
    private Set<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
    private final BeanManagerImpl manager;

    public MergedStereotypes(Set<Annotation> stereotypeAnnotations, BeanManagerImpl manager) {
        this.manager = manager;
        this.merge(stereotypeAnnotations);
    }

    protected void merge(Set<Annotation> stereotypeAnnotations) {
        for (Annotation stereotypeAnnotation : stereotypeAnnotations) {
            StereotypeModel<? extends Annotation> stereotype = this.manager.getServices().get(MetaAnnotationStore.class).getStereotype(stereotypeAnnotation.annotationType());
            if (stereotype == null) {
                throw new IllegalStateException("Stereotype " + stereotypeAnnotation + " not registered with container");
            }
            if (stereotype.isPolicy()) {
                this.policy = true;
            }
            if (stereotype.getDefaultScopeType() != null) {
                this.possibleScopeTypes.add(stereotype.getDefaultScopeType());
            }
            if (stereotype.isBeanNameDefaulted()) {
                this.beanNameDefaulted = true;
            }
            this.stereotypes.add(stereotypeAnnotation.annotationType());
            this.merge(stereotype.getInheritedSterotypes());
        }
    }

    public boolean isPolicy() {
        return this.policy;
    }

    public Set<Annotation> getPossibleScopeTypes() {
        return this.possibleScopeTypes;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public String toString() {
        return "Merged stereotype model; Any of the sterotypes is a policy: " + this.policy + "; possible scopes " + this.possibleScopeTypes;
    }
}

