/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorates;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.stereotype.Stereotype;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBParameter;
import org.jboss.webbeans.literal.AnyLiteral;
import org.jboss.webbeans.literal.DefaultLiteral;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.cache.MergedStereotypes;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T, E>
extends RIBean<T> {
    private static final Annotation ANY_LITERAL = new AnyLiteral();
    private static final Annotation CURRENT_LITERAL = new DefaultLiteral();
    private boolean proxyable;
    private final Log log = Logging.getLog(AbstractBean.class);
    protected Set<Annotation> bindings;
    protected String name;
    protected Class<? extends Annotation> scopeType;
    private MergedStereotypes<T, E> mergedStereotypes;
    private boolean policy;
    protected Class<T> type;
    protected Set<Type> types;
    private Set<WBInjectionPoint<?, ?>> injectionPoints;
    private Set<WBInjectionPoint<?, ?>> delegateInjectionPoints;
    private boolean primitive;
    protected BeanManagerImpl manager;
    private boolean _serializable;
    private boolean initialized;

    protected boolean isInitialized() {
        return this.initialized;
    }

    public AbstractBean(BeanManagerImpl manager) {
        super(manager);
        this.manager = manager;
        this.injectionPoints = new HashSet();
        this.delegateInjectionPoints = new HashSet();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (this.isSpecializing()) {
            this.preSpecialize(environment);
            this.specialize(environment);
            this.postSpecialize();
        }
        this.initDefaultBindings();
        this.initPrimitive();
        this.log.trace((Object)"Building Web Bean bean metadata for #0", this.getType());
        this.initName();
        this.initScopeType();
        this.initSerializable();
        this.initProxyable();
        this.checkDelegateInjectionPoints();
    }

    protected void initStereotypes() {
        this.mergedStereotypes = new MergedStereotypes(this.getAnnotatedItem().getMetaAnnotations(Stereotype.class), this.manager);
    }

    protected void checkDelegateInjectionPoints() {
        if (this.delegateInjectionPoints.size() > 0) {
            throw new DefinitionException("Cannot place @Decorates at an injection point which is not on a Decorator " + this);
        }
    }

    protected void addInjectionPoint(WBInjectionPoint<?, ?> injectionPoint) {
        if (injectionPoint.isAnnotationPresent(Decorates.class)) {
            this.delegateInjectionPoints.add(injectionPoint);
        }
        this.injectionPoints.add(injectionPoint);
    }

    protected void addInjectionPoints(Iterable<? extends WBInjectionPoint<?, ?>> injectionPoints) {
        for (WBInjectionPoint<?, ?> injectionPoint : injectionPoints) {
            this.addInjectionPoint(injectionPoint);
        }
    }

    protected Set<WBInjectionPoint<?, ?>> getDelegateInjectionPoints() {
        return this.delegateInjectionPoints;
    }

    protected void initTypes() {
        this.types = this.getAnnotatedItem().getTypeClosure();
    }

    protected void initBindings() {
        this.bindings = new HashSet<Annotation>();
        this.bindings.addAll(this.getAnnotatedItem().getMetaAnnotations(Qualifier.class));
        this.initDefaultBindings();
        this.log.trace((Object)("Using binding types " + this.bindings + " specified by annotations"), new Object[0]);
    }

    protected void initDefaultBindings() {
        if (this.bindings.size() == 0) {
            this.log.trace((Object)"Adding default @Current binding type", new Object[0]);
            this.bindings.add(CURRENT_LITERAL);
        }
        this.bindings.add(ANY_LITERAL);
    }

    protected void initPolicy() {
        this.policy = this.getAnnotatedItem().isAnnotationPresent(Alternative.class) ? true : this.getMergedStereotypes().isPolicy();
    }

    protected void initName() {
        boolean beanNameDefaulted = false;
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class)) {
            String javaName = this.getAnnotatedItem().getAnnotation(Named.class).value();
            if ("".equals(javaName)) {
                this.log.trace((Object)"Using default name (specified by annotations)", new Object[0]);
                beanNameDefaulted = true;
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Using name " + javaName + " specified by annotations"), new Object[0]);
                }
                this.name = javaName;
                return;
            }
        }
        if (beanNameDefaulted || this.getMergedStereotypes().isBeanNameDefaulted()) {
            this.name = this.getDefaultName();
            return;
        }
    }

    protected void initProxyable() {
        this.proxyable = this.getAnnotatedItem().isProxyable();
    }

    protected void initPrimitive() {
        this.primitive = Reflections.isPrimitive(this.getType());
    }

    private boolean checkInjectionPointsAreSerializable() {
        boolean passivating = this.manager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isPassivating();
        for (WBInjectionPoint<?, ?> injectionPoint : this.getAnnotatedInjectionPoints()) {
            Annotation[] bindings = injectionPoint.getMetaAnnotationsAsArray(Qualifier.class);
            Bean<?> resolvedBean = this.manager.getBeans(injectionPoint.getJavaClass(), bindings).iterator().next();
            if (!passivating || !Dependent.class.equals(resolvedBean.getScope()) || Reflections.isSerializable(resolvedBean.getBeanClass()) || (!(injectionPoint instanceof WBField) || ((WBField)((Object)injectionPoint)).isTransient()) && !(injectionPoint instanceof WBParameter)) continue;
            return false;
        }
        return true;
    }

    protected abstract void initScopeType();

    protected boolean initScopeTypeFromStereotype() {
        Set<Annotation> possibleScopeTypes = this.getMergedStereotypes().getPossibleScopeTypes();
        if (possibleScopeTypes.size() == 1) {
            this.scopeType = possibleScopeTypes.iterator().next().annotationType();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Scope " + this.scopeType + " specified by stereotype"), new Object[0]);
            }
            return true;
        }
        if (possibleScopeTypes.size() > 1) {
            throw new DefinitionException("All stereotypes must specify the same scope OR a scope must be specified on " + this.getAnnotatedItem());
        }
        return false;
    }

    protected void postSpecialize() {
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class) && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            throw new DefinitionException("Cannot put name on specializing and specialized class " + this.getAnnotatedItem());
        }
        this.bindings.addAll(((AbstractBean)this.getSpecializedBean()).getQualifiers());
        if (this.isSpecializing() && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            this.name = ((AbstractBean)this.getSpecializedBean()).getName();
        }
        this.manager.getSpecializedBeans().put(this.getSpecializedBean(), this);
    }

    protected void preSpecialize(BeanDeployerEnvironment environment) {
    }

    protected void specialize(BeanDeployerEnvironment environment) {
    }

    protected abstract WBAnnotated<T, E> getAnnotatedItem();

    @Override
    public Set<Annotation> getQualifiers() {
        return this.bindings;
    }

    protected abstract String getDefaultName();

    public abstract AbstractBean<?, ?> getSpecializedBean();

    @Override
    public Set<WBInjectionPoint<?, ?>> getAnnotatedInjectionPoints() {
        return this.injectionPoints;
    }

    protected MergedStereotypes<T, E> getMergedStereotypes() {
        return this.mergedStereotypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isAssignableFrom(WBAnnotated<?, ?> annotatedItem) {
        return this.getAnnotatedItem().isAssignableFrom(annotatedItem);
    }

    @Override
    public boolean isNullable() {
        return !this.isPrimitive();
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isSerializable() {
        return this._serializable && this.checkInjectionPointsAreSerializable();
    }

    protected void initSerializable() {
        this._serializable = Reflections.isSerializable(this.type);
    }

    public String toString() {
        return "AbstractBean " + this.getName();
    }

    @Override
    public boolean isProxyable() {
        return this.proxyable;
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.getScope());
    }

    @Override
    public boolean isAlternative() {
        return this.policy;
    }

    @Override
    public boolean isSpecializing() {
        return this.getAnnotatedItem().isAnnotationPresent(Specializes.class);
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.mergedStereotypes.getStereotypes();
    }
}

