/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.interceptor.Interceptor;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanInstance;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.webbeans.bean.proxy.Marker;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.ejb.InternalEjbDescriptor;
import org.jboss.webbeans.ejb.api.SessionObjectReference;
import org.jboss.webbeans.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.injection.InjectionContextImpl;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Proxies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBean<T>
extends AbstractClassBean<T> {
    private final Log log = Logging.getLog(SessionBean.class);
    private InternalEjbDescriptor<T> ejbDescriptor;
    private Class<T> proxyClass;
    private SessionBean<?> specializedBean;

    public static <T> SessionBean<T> of(InternalEjbDescriptor<T> ejbDescriptor, BeanManagerImpl manager) {
        WBClass type = manager.getServices().get(ClassTransformer.class).loadClass(ejbDescriptor.getBeanClass());
        return new SessionBean(type, ejbDescriptor, manager);
    }

    protected SessionBean(WBClass<T> type, InternalEjbDescriptor<T> ejbDescriptor, BeanManagerImpl manager) {
        super(type, manager);
        this.initType();
        this.ejbDescriptor = ejbDescriptor;
        this.initTypes();
        this.initBindings();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.initProxyClass();
            this.checkEJBTypeAllowed();
            this.checkConflictingRoles();
            this.checkObserverMethods();
            this.checkScopeAllowed();
        }
    }

    @Override
    protected void initTypes() {
        HashSet types = new HashSet();
        types = new LinkedHashSet();
        types.add(Object.class);
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : this.ejbDescriptor.getLocalBusinessInterfaces()) {
            types.add(businessInterfaceDescriptor.getInterface());
        }
        this.types = types;
    }

    protected void initProxyClass() {
        Class proxyClass;
        LinkedHashSet<Type> types = new LinkedHashSet<Type>(this.getTypes());
        types.add((Type)((Object)EnterpriseBeanInstance.class));
        types.add((Type)((Object)Serializable.class));
        ProxyFactory proxyFactory = Proxies.getProxyFactory(types);
        this.proxyClass = proxyClass = proxyFactory.createClass();
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException("Enterprise beans cannot be interceptors");
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw new DefinitionException("Enterprise beans cannot be decorators");
        }
    }

    protected void checkScopeAllowed() {
        if (this.ejbDescriptor.isStateless() && !this.isDependent()) {
            throw new DefinitionException("Scope " + this.getScope() + " is not allowed on stateless enterpise beans for " + this.getType() + ". Only @Dependent is allowed on stateless enterprise beans");
        }
        if (this.ejbDescriptor.isSingleton() && !this.isDependent() && !this.getScope().equals(ApplicationScoped.class)) {
            throw new DefinitionException("Scope " + this.getScope() + " is not allowed on singleton enterpise beans for " + this.getType() + ". Only @Dependent or @ApplicationScoped is allowed on singleton enterprise beans");
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (!environment.getEjbDescriptors().contains(this.getAnnotatedItem().getWBSuperclass().getJavaClass())) {
            throw new DefinitionException("Annotation defined specializing EJB must have EJB superclass");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        if (environment.getClassBean(this.getAnnotatedItem().getWBSuperclass()) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        AbstractClassBean<?> specializedBean = environment.getClassBean(this.getAnnotatedItem().getWBSuperclass());
        if (!(specializedBean instanceof SessionBean)) {
            throw new IllegalStateException(this.toString() + " doesn't have a session bean as a superclass " + specializedBean);
        }
        this.specializedBean = (SessionBean)specializedBean;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = this.produce(creationalContext);
        if (this.hasDecorators()) {
            instance = this.applyDecorators(instance, creationalContext, null);
        }
        return instance;
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx) {
        new InjectionContextImpl<T>(this.getManager(), this, instance){

            @Override
            public void proceed() {
                Beans.injectBoundFields(instance, ctx, SessionBean.this.getManager(), SessionBean.this.getInjectableFields());
                Beans.callInitializers(instance, ctx, SessionBean.this.getManager(), SessionBean.this.getInitializerMethods());
            }
        }.run();
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        try {
            T instance = this.proxyClass.newInstance();
            ctx.push(instance);
            ((ProxyObject)instance).setHandler(new EnterpriseBeanProxyMethodHandler<T>(this, ctx));
            this.log.trace((Object)"Enterprise bean instance created for bean {0}", this);
            return instance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate enterprise proxy for " + this.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access bean correctly when creating enterprise proxy for " + this.toString(), e);
        }
        catch (Exception e) {
            throw new CreationException("could not find the EJB in JNDI " + this.proxyClass, e);
        }
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (instance == null) {
            throw new IllegalArgumentException("instance to destroy cannot be null");
        }
        if (!(instance instanceof EnterpriseBeanInstance)) {
            throw new IllegalArgumentException("Cannot destroy session bean instance not created by the container");
        }
        EnterpriseBeanInstance enterpiseBeanInstance = (EnterpriseBeanInstance)instance;
        enterpiseBeanInstance.destroy(Marker.INSTANCE, this, creationalContext);
        creationalContext.release();
    }

    private void checkEJBTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw new DefinitionException("Message Driven Beans can't be Web Beans");
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getName() == null) {
            buffer.append(" unnamed enterprise bean");
        } else {
            buffer.append(" enterprise bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "] ");
        buffer.append("API types " + this.getTypes() + ", binding types " + this.getQualifiers());
        return buffer.toString();
    }

    public void postConstruct(T instance, CreationalContext<T> creationalContext) {
        Beans.injectBoundFields(instance, creationalContext, this.getManager(), this.getInjectableFields());
        Beans.callInitializers(instance, creationalContext, this.getManager(), this.getInitializerMethods());
    }

    @Override
    public void preDestroy(CreationalContext<T> creationalContext) {
        creationalContext.release();
    }

    @Override
    protected void initSerializable() {
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    public InternalEjbDescriptor<T> getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean isClientCanCallRemoveMethods() {
        return this.getEjbDescriptor().isStateful() && this.isDependent();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    protected void checkObserverMethods() {
        for (WBMethod method : this.annotatedItem.getWBDeclaredMethodsWithAnnotatedParameters(Observes.class)) {
            if (method.isStatic() || this.isMethodExistsOnTypes(method)) continue;
            throw new DefinitionException("Observer method must be static or business method: " + method + " on " + this.getAnnotatedItem());
        }
    }

    public boolean isMethodExistsOnTypes(WBMethod<?, ?> method) {
        for (Type type : this.getTypes()) {
            if (!(type instanceof Class)) continue;
            for (Method m : ((Class)type).getMethods()) {
                if (!method.getName().equals(m.getName()) || !Arrays.equals(method.getParameterTypesAsArray(), m.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public SessionObjectReference createReference() {
        return this.manager.getServices().get(EjbServices.class).resolveEjb(this.getEjbDescriptor().delegate());
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }
}

