/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans;

import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.webbeans.WebBeansDeployer;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.WebBeansBootstrap;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class JCDIServiceImpl
implements JCDIService {
    @Inject
    private WebBeansDeployer webBeansDeployer;
    @Inject
    private Habitat h;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;

    public boolean isCurrentModuleJCDIEnabled() {
        BundleDescriptor bundle = null;
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(inv.getComponentId());
        if (componentEnv != null) {
            if (componentEnv instanceof BundleDescriptor) {
                bundle = (BundleDescriptor)componentEnv;
            } else if (componentEnv instanceof com.sun.enterprise.deployment.EjbDescriptor) {
                bundle = ((com.sun.enterprise.deployment.EjbDescriptor)componentEnv).getEjbBundleDescriptor();
            }
        }
        return bundle != null ? this.isJCDIEnabled(bundle) : false;
    }

    public boolean isJCDIEnabled(BundleDescriptor bundle) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        return this.webBeansDeployer.is299Enabled(topLevelBundleDesc);
    }

    public JCDIService.JCDIInjectionContext injectEJBInstance(com.sun.enterprise.deployment.EjbDescriptor ejb, Object instance) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)ejb.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.webBeansDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WebBeansBootstrap bootstrap = this.webBeansDeployer.getBootstrapForApp(ejb.getEjbBundleDescriptor().getApplication());
        BeanManagerImpl webBeansManager = bootstrap.getManager(bda);
        EjbDescriptor ejbDesc = webBeansManager.getEjbDescriptor(ejb.getName());
        Bean bean = webBeansManager.getBean(ejbDesc);
        InjectionTarget it = webBeansManager.createInjectionTarget(ejbDesc);
        CreationalContext cc = webBeansManager.createCreationalContext((Contextual)bean);
        it.inject(instance, cc);
        return new JCDIInjectionContextImpl(it, cc, instance);
    }

    public JCDIService.JCDIInjectionContext createManagedObject(Class managedClass, BundleDescriptor bundle) {
        Object managedObject = null;
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.webBeansDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        WebBeansBootstrap bootstrap = this.webBeansDeployer.getBootstrapForApp(bundle.getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(managedClass);
        InjectionTarget it = beanManager.createInjectionTarget(annotatedType);
        CreationalContext cc = beanManager.createCreationalContext(null);
        managedObject = it.produce(cc);
        it.inject(managedObject, cc);
        it.postConstruct(managedObject);
        return new JCDIInjectionContextImpl(it, cc, managedObject);
    }

    private class JCDIInjectionContextImpl
    implements JCDIService.JCDIInjectionContext {
        private InjectionTarget it;
        private CreationalContext cc;
        private Object instance;

        JCDIInjectionContextImpl(InjectionTarget it, CreationalContext cc, Object i) {
            this.it = it;
            this.cc = cc;
            this.instance = i;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void cleanup(boolean callPreDestroy) {
            if (callPreDestroy) {
                this.it.preDestroy(this.instance);
            }
            this.it.dispose(this.instance);
            this.cc.release();
        }
    }
}

