/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.reflect.Field;
import javax.enterprise.inject.spi.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.jlr.AbstractWBMember;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBFieldImpl<T, X>
extends AbstractWBMember<T, X, Field>
implements WBField<T, X> {
    private final Field field;
    private String toString;

    public static <T, X> WBFieldImpl<T, X> of(Field field, WBClass<X> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(field, classTransformer.getTypeStore());
        return new WBFieldImpl<T, X>(Reflections.ensureAccessible(field), annotationStore, declaringClass, classTransformer);
    }

    public static <T, X> WBFieldImpl<T, X> of(AnnotatedField<? super X> annotatedField, WBClass<X> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(annotatedField.getAnnotations(), annotatedField.getAnnotations(), classTransformer.getTypeStore());
        return new WBFieldImpl<T, X>(Reflections.ensureAccessible(annotatedField.getJavaMember()), annotationStore, declaringClass, classTransformer);
    }

    private WBFieldImpl(Field field, AnnotationStore annotationStore, WBClass<X> declaringClass, ClassTransformer classTransformer) {
        super(annotationStore, field, field.getType(), field.getGenericType(), declaringClass);
        this.field = field;
    }

    public Field getAnnotatedField() {
        return this.field;
    }

    @Override
    public Field getDelegate() {
        return this.field;
    }

    @Override
    public void set(Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(instance, value);
    }

    public void setOnInstance(Object instance, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        instance.getClass().getField(this.getName()).set(instance, value);
    }

    @Override
    public T get(Object instance) {
        return (T)Reflections.getAndWrap(this.getDelegate(), instance);
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = Names.fieldToString(this.field) + " on " + this.getDeclaringType();
        return this.toString;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof WBField) {
            WBField that = (WBField)other;
            return this.getDeclaringType().equals(that.getDeclaringType()) && this.getName().equals(that.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

