/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bootstrap.BeanDeployment;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.bootstrap.api.Singleton;
import org.jboss.webbeans.bootstrap.api.SingletonProvider;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container {
    private static final Singleton<Container> instance = SingletonProvider.instance().create(Container.class);
    private final BeanManagerImpl deploymentManager;
    private final Map<Integer, BeanManagerImpl> activities;
    private final Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives;
    private final ServiceRegistry deploymentServices;
    private boolean initialized = false;

    public static Container instance() {
        return instance.get();
    }

    public static void initialize(BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        Container instance = new Container(deploymentManager, deploymentServices);
        Container.instance.set(instance);
    }

    public Container(BeanManagerImpl deploymentManager, ServiceRegistry deploymentServices) {
        this.deploymentManager = deploymentManager;
        this.activities = new ConcurrentHashMap<Integer, BeanManagerImpl>();
        this.activities.put(deploymentManager.getId(), deploymentManager);
        this.beanDeploymentArchives = new ConcurrentHashMap<BeanDeploymentArchive, BeanManagerImpl>();
        this.deploymentServices = deploymentServices;
    }

    public void cleanup() {
        this.activities.clear();
        for (BeanManagerImpl beanManager : this.beanDeploymentArchives.values()) {
            beanManager.cleanup();
        }
        this.beanDeploymentArchives.clear();
        this.deploymentServices.cleanup();
        this.deploymentManager.cleanup();
    }

    public BeanManagerImpl deploymentManager() {
        return this.deploymentManager;
    }

    public Map<BeanDeploymentArchive, BeanManagerImpl> beanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public BeanManagerImpl activityManager(Integer key) {
        return this.activities.get(key);
    }

    public Integer addActivity(BeanManagerImpl manager) {
        Integer id = manager.getId();
        this.activities.put(id, manager);
        return id;
    }

    public ServiceRegistry deploymentServices() {
        return this.deploymentServices;
    }

    public void putBeanDeployments(Map<BeanDeploymentArchive, BeanDeployment> beanDeployments) {
        for (Map.Entry<BeanDeploymentArchive, BeanDeployment> entry : beanDeployments.entrySet()) {
            this.beanDeploymentArchives.put(entry.getKey(), entry.getValue().getBeanManager());
            this.addActivity(entry.getValue().getBeanManager());
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

